﻿/*
 *	
 *	
 *	
 */

package org.pizarra.Data{	

	import flash.display.Scene;
	import org.pizarra.Estado;
	import org.pizarra.util.Constantes;
	
	import org.pizarra.Util;
	import flash.data.SQLResult;
	import flash.data.SQLConnection;
	import flash.filesystem.File;
	import flash.data.SQLStatement;
	import flash.data.SQLConnection;
	import flash.errors.SQLError;
	import flash.events.SQLErrorEvent;
	import flash.events.SQLEvent;
	import flash.events.MouseEvent;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.Jugador;
	import flash.geom.Point;
	import org.pizarra.configuracion.Preferencias;
	import org.pizarra.util.DBConstants;
	import org.pizarra.Entity.*;
	import org.pizarra.configuracion.*;

	public class Base_Datos{
		
		private var file:String;
		var conn:SQLConnection;
		var q: SQLStatement;
		var createStmt:SQLStatement;
		private var insertStmt:SQLStatement;
		private var updateStmt:SQLStatement;
		var insertStmt2:SQLStatement;
		var deleteStmt: SQLStatement;
		var selectStmt:SQLStatement;
		var selectStmt2:SQLStatement;
		var result:SQLResult;		//	Almacena los resultados obtenidos por las consultas
		var result2:SQLResult;
		var result3:SQLResult;
		
		private var texto;
		/*
		 *	Estado de la base de datos
		 *	Se considera preparada cuando esta conectada con bd correcta, se utiliza de
		 *	guarda de seguridad para todos los accesos a la base de datos
		 */
		var preparada: Boolean = false;	
		
		/*
		 *	BASEDATOS()
		 *	Constructor que a partir de la cadena con el nombre de la base de datos establece 
		 *	la conexión con la misma
		 *	Devuelve true en caso de conexion correcta y false en caso de error
		 */
		public function Base_Datos( nombreFichero:String, texto ){
			
			this.preparada = false;
			conn = new SQLConnection();
			this.texto = texto;  				/************/
			var dbFile:File; 
			if (File.documentsDirectory.resolvePath("piz/"+nombreFichero).exists){
				dbFile = File.documentsDirectory.resolvePath("piz/"+nombreFichero);
			}else{
				throw new Error('Something went wrong.  DAMN!');
				return;
			}
			
			//texto.texto = dbFile.nativePath;
			try{
				q = new SQLStatement();
				q.sqlConnection = conn;
        		conn.open(dbFile);
				Util.subTrace("Base de datos abierta Correctamente " + dbFile.nativePath);
    		}catch (error:SQLError){
        		Util.subTrace("ERROR ABRIENDO BBDD "+error.message+" "+error.details);
    		}
			this.preparada = true;
		}
		
		public function close() {
			conn.close();
			trace("conexion cerrada");
		}
		
		/*
		 *	Lee todos los deportes de la base de datos
		 */
		public function lee_deportes():Array{
			
			var deportes: Array = new Array();
			
			if(this.preparada){	//	Base de datos preparada
				q.text = "SELECT Id, Nombre, Thumb FROM Deporte";
				try{q.execute();
   					result=q.getResult();
   					if(result.data){
     					var numResults:int = result.data.length;
     					for (var i:int = 0; i < numResults; i++){
							deportes[i] = result.data[i].Nombre;
        				}
   					}
				}catch (error:SQLError){
					throw new Error(error.message); 
  					return null;
				}
				return deportes;
			}else{
				return null;
			}
		}
		
		public function existe_deporte(dep: String):Boolean{
			
			if(this.preparada){	//	Base de datos preparada
				q.text = "select Nombre from Deporte where Nombre ='" + dep +"'";
				try{	q.execute();
   						result=q.getResult();
   						if(result.data){	return true;
   						}else{	return false;	}
				}catch (error:SQLError){
  					return true;
				}
			}else{
				return true;
			}
			return true;
		}
		
		/*
		 *	Lee todos las preferencias de la base de datos
		 */
		public function get_preferencias():Preferencias{
			
			var prefs: Preferencias = new Preferencias();
			
			if(this.preparada){	//	Base de datos preparada
				q.text = "select * from preferencias";
				try{
   					q.execute();
   					result=q.getResult();
   					if(result.data){
						trace("get preferencias")
     					prefs.tablet = result.data[0]["tablet_mode"];
						Settings.Tablet = result.data[0]["tablet_mode"];
						prefs.pdf = result.data[0]["pdf"];
						Settings.Pdf = result.data[0]["pdf"];
						prefs.video = result.data[0]["video"];
						Settings.Video = result.data[0]["video"];
						prefs.bez_color = result.data[0]["bez_color"];
						Settings.Bez_color = result.data[0]["bez_color"];
						prefs.line_color = result.data[0]["line_color"];
						Settings.Line_color = result.data[0]["line_color"];
						prefs.point_color = result.data[0]["point_color"];
						Settings.Point_color = result.data[0]["point_color"];
						prefs.border_color = result.data[0]["border_color"];
						Settings.Border_color = result.data[0]["border_color"];
						prefs.server = result.data[0]["server"];
						Settings.Server = result.data[0]["server"];
						prefs.calidad = result.data[0]["calidad"];
						Settings.Calidad = result.data[0]["calidad"];
						//	New
						Settings.ShowPathOnAnimation = ((int)(result.data[0]["ShowPathOnAnimation"]) == 0 ? false : true);
						Settings.ShowPathOnTimeline = ((int)(result.data[0]["ShowPathOnTimeline"]) == 0 ? false : true);
						Settings.ShowPointsOnAnimation = ((int)(result.data[0]["ShowPointsOnAnimation"]) == 0 ? false : true);
						Settings.OpenPdfAfterGenerating = ((int)(result.data[0]["OpenPdfAfterGenerating"]) == 0 ? false : true);
						Settings.OpenVideoAfterGenerating = ((int)(result.data[0]["OpenVideoAfterGenerating"]) == 0 ? false : true);
						
						trace(Settings.ShowPathOnAnimation + "_" + Settings.ShowPathOnTimeline);
   					}
				}catch (error:SQLError){
					throw new Error(error.message); 
  					return null;
				}
				return prefs;
			}else{
				return null;
			}
		}
		
		//	Escribe las preferencias en la base de datos
		//	Para añadir más elementos de configuración actualizar la consulta
		public function set_preferencias(prefs: Preferencias):void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "update preferencias set video = '" + prefs.video + "', ";
			insertStmt.text +="pdf = '" + prefs.pdf + "', ";
			insertStmt.text +="tablet_mode =" + prefs.tablet + ", ";
			insertStmt.text +="bez_color = '" + prefs.bez_color + "', ";
			insertStmt.text +="point_color = '" + prefs.point_color + "', ";
			insertStmt.text +="border_color = '" + prefs.border_color + "', ";
			insertStmt.text +="server = '" + prefs.server + "', ";
			insertStmt.text +="calidad = " + prefs.calidad + ", ";
			insertStmt.text +="line_color = '" + prefs.line_color + "'";
			
			trace(insertStmt.text);
			insertStmt.execute();
		}
		
		public function set_preferencias_from_Settings():void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "update preferencias set video = '" + Settings.Video + "', ";
			insertStmt.text +="pdf = '" + Settings.Pdf + "', ";
			insertStmt.text +="tablet_mode =" + Settings.Tablet + ", ";
			insertStmt.text +="bez_color = '" + Settings.Bez_color + "', ";
			insertStmt.text +="point_color = '" + Settings.Point_color + "', ";
			insertStmt.text +="border_color = '" + Settings.Border_color + "', ";
			insertStmt.text +="server = '" + Settings.Server + "', ";
			insertStmt.text +="calidad = " + Settings.Calidad + ", ";
			insertStmt.text +="line_color = '" + Settings.Line_color + "' ,";
			//	New
			insertStmt.text +="ShowPathOnAnimation = " + (Settings.ShowPathOnAnimation ? "1" : "0") + " ,";
			insertStmt.text +="ShowPathOnTimeline = " +  (Settings.ShowPathOnTimeline ? "1" : "0") + " ,";
			insertStmt.text +="ShowPointsOnAnimation = " +  (Settings.ShowPointsOnAnimation ? "1" : "0") + " ,";
			insertStmt.text +="OpenPdfAfterGenerating = " +  (Settings.OpenPdfAfterGenerating ? "1" : "0") + " ,";
			insertStmt.text +="OpenVideoAfterGenerating = " +  (Settings.OpenVideoAfterGenerating ? "1" : "0") ;
			
			trace(insertStmt.text);
			insertStmt.execute();
		}
		
		/*
		 *	Lee las cabeceras de los ejercicios de la base de datos
		 */
		public function lee_ejercicios():Array{
			
			var v:Array = new Array();
			var aux_id:int;
			var aux_date:String;
			var aux_nombre:String;
			var aux_data: String;
			var e: Ejercicio;
			
			if(this.preparada){			//	Base de datos preparada
				selectStmt = new SQLStatement();
				selectStmt.sqlConnection = conn;
				var sql:String = "SELECT * FROM ejercicios";
				selectStmt.text = sql;
			
				try{
					selectStmt.execute();
				}catch (error){
					trace("SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details);
					return null;
				}
				result = selectStmt.getResult();
				if(result.data != null){
					var numRows:int = result.data.length;
					for (var i:int = 0; i < numRows; i++){
						e = new Ejercicio(	result.data[i]["id_ejercicio"],
											result.data[i]["nombre"],
											result.data[i]["info"],
											result.data[i]["fecha"],
											result.data[i]["tipo"],
											result.data[i]["deporte"],0);
						v[i] = e;
					}				
					return v;
				}else{
					return new Array();
				}
			}else{
				return new Array();
			}
		}
		
		//	Lee el ejercicio con la id pasada cómo parámetro, y lo almacena en la referencia al ejercicio pasado 
		//	también como parámetro, a su vez devuelve el ejercicio
		public function lee_ejercicio(id: String, ej: Ejercicio): Ejercicio{
			
			//var ej: Ejercicio = ej;
			var numRows,numRows2,numRows3:int;
			var i,j,k: int;
			var inicio: Point;
			var fin: Point;
			var escenas: Array = new Array();
			var movimientos: Array = new Array();
			var trayectorias: Array = new Array();
			var sql:String = "select * from escena where id_ejercicio = '" + id + "'";
			
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = sql; 
			
			try{
				selectStmt.execute();
				result = selectStmt.getResult();
				numRows = result.data.length;
				for (i = 0; i < numRows; i++){
					escenas[i+1]= new Escena(	result.data[i]["id_escena"],
												result.data[i]["tipo"],
												result.data[i]["duracion"],
												result.data[i]["texto"],
												result.data[i]["audio"]);
												
					sql = "select * from movimiento where id_ejercicio = '" + id + "' and id_escena = '"+result.data[i]["id_escena"] +"'";
					selectStmt.text = sql;	
					selectStmt.execute();
					result2 = selectStmt.getResult();	
					numRows2 = result2.data.length;
					
					for (j = 0; j < numRows2; j++){
						inicio = new Point(result2.data[j]["x_inicio"],result2.data[j]["y_inicio"]);
						fin = new Point(result2.data[j]["x_fin"],result2.data[j]["y_fin"]);
						movimientos.push(new Movimiento(result2.data[j]["id_movimiento"],
														result2.data[j]["tipo"], inicio, fin,0,
														result2.data[j]["elemento"],
														result2.data[j]["etiqueta"],j));
						//	Tiene trayectoria
						sql  = "select * from trayectoria where id_ejercicio = '" + id + "' and id_escena = '" + result.data[i]["id_escena"]+"'";
						sql += " and id_movimiento = " + result2.data[j]["id_movimiento"];
						selectStmt.text = sql;	
						selectStmt.execute();
						result3 = selectStmt.getResult();	
						if(result3.data != null){
							numRows3 = result3.data.length;
							trayectorias = new Array();
							for(k=0; k< numRows3; k++){
								trayectorias.push(new Point(result3.data[k]["x"],result3.data[k]["y"]))
							}
							movimientos[j].set_trayectorias(trayectorias);
						}
					}
					escenas[i+1].set_movimientos(movimientos.concat( ));
					movimientos = new Array();		
				}
				ej.set_escenas(escenas.concat( ));
			}catch (error){
				trace(error);
				return null;
			}
			return ej;
		}
		
		public function lee_elementos(deportes: Array): Array{
			
			var i: int;
			var j: int;
			var e_d: Array = new Array();
			var elementos: Array; 

			
			if(this.preparada){	//	Base de datos preparada
			
				for(i=0;i<deportes.length;i++){//	Busco los elementos de ese deporte
					elementos = new Array();
					q.text = "select * from elemento natural join tiene_elementos where deporte='"+deportes[i]+"'";
					try{
   						q.execute();
   						result=q.getResult();
   						if(result.data){
     						var numResults:int = result.data.length;
     						for (j = 0; j < numResults; j++){
								elementos[j] = new ElementoBE(result.data[j].id_elemento,
															result.data[j].nombre,
															result.data[j].tipo,
															Constantes.BASE_URL + result.data[j].imagen + ".png",
															result.data[j].altura,
															result.data[j].anchura);
        					}
   						}
					}catch (error:SQLError){
  						return null;
					}
					e_d[i] = elementos;
				}
				return e_d;
			}else{
				return null;
			}
		}
		
		public function lee_elementos_estaticos(deportes: Array): Array{
			
			var i: int;
			var j: int;
			var e_d: Array = new Array();
			var elementos: Array; 
			
			if(this.preparada){	//	Base de datos preparada
			
				for(i=0;i<deportes.length;i++){//	Busco los elementos de ese deporte
					elementos = new Array();
					q.text = "select * from elemento natural join tiene_elementos where deporte='"+deportes[i]+"' and tipo='estatico'";
					try{
   						q.execute();
   						result=q.getResult();
   						if(result.data){
     						var numResults:int = result.data.length;
     						for (j = 0; j < numResults; j++){
								elementos[j] = new ElementoBE(result.data[j].id_elemento,
															result.data[j].nombre,
															result.data[j].tipo,
															Constantes.BASE_URL + result.data[j].imagen + ".png",
															result.data[j].altura,
															result.data[j].anchura);
								//trace("eeee" + elementos[j].imagen);
        					}
   						}
					}catch (error:SQLError){
  						return null;
					}
					e_d[i] = elementos;
				}
				return e_d;
			}else{
				return null;
			}
		}
		
		public function lee_elementos_dinamicos(deportes: Array): Array{
			
			var i: int;
			var j: int;
			var e_d: Array = new Array();
			var elementos: Array; 
			
			if(this.preparada){	//	Base de datos preparada
			
				for(i=0;i<deportes.length;i++){//	Busco los elementos de ese deporte
					elementos = new Array();
					q.text = "select * from elemento natural join tiene_elementos where deporte='"+deportes[i]+"' and tipo= 'dinamico'";
					try{
   						q.execute();
   						result=q.getResult();
   						if(result.data){
     						var numResults:int = result.data.length;
     						for (j = 0; j < numResults; j++){
								elementos[j] = new ElementoBE(result.data[j].id_elemento,
															result.data[j].nombre,
															result.data[j].tipo,
															Constantes.BASE_URL + result.data[j].imagen + ".png",
															result.data[j].altura,
															result.data[j].anchura);
        					}
   						}
					}catch (error:SQLError){
  						return null;
					}
					e_d[i] = elementos;
				}
				return e_d;
			}else{
				return null;
			}
		}
		
		public function lee_fondos(deportes: Array): Array{
			
			var i: int;
			var j: int;
			var e_d: Array = new Array();
			var elementos: Array; 
			
			if(this.preparada){	//	Base de datos preparada
			
				for(i=0;i<deportes.length;i++){//	Busco los elementos de ese deporte
					elementos = new Array();
					q.text = "select * from fondo natural join tiene_fondos where deporte='"+deportes[i]+"'";
					try{
   						q.execute();
   						result=q.getResult();
   						if(result.data){
     						var numResults:int = result.data.length;
     						for (j = 0; j < numResults; j++){
								elementos[j] = new Fondo(	result.data[j].Id,
															Constantes.BASE_URL + result.data[j].imagen,
															result.data[j].nombre,
															result.data[j].m_alto,
															result.data[j].m_ancho,
															result.data[j].altura,
															result.data[j].anchura);
								//elementos[j].escribe();
								trace("deporte " + i + " fondo " + j + " id " + elementos[j].id);
        					}
   						}
					}catch (error:SQLError){
  						return null;
					}
					e_d[i] = elementos;
				}
				return e_d;
			}else{
				return null;
			}
		}
		
		public function lee_jugadores(): Array{
			
			var j: int;
			var elementos: Array = new Array(); 
			var jugador: Jugador;
			if(this.preparada){	//	Base de datos preparada
				elementos = new Array();
				q.text = "select * from jugadores";
				try{
   					q.execute();
   					result=q.getResult();
   					if(result.data){
     					var numResults:int = result.data.length;
     					for (j = 0; j < numResults; j++){
							jugador = new Jugador(result.data[j]["id_jugador"],result.data[j].url,result.data[j].nombre);
							elementos[j] = jugador;
        				}
   					}
				}catch (error:SQLError){
  					return elementos;
				}
				return elementos;
			}else{
				return elementos;
			}
		}
		
		
		public function filtra_ejercicios(q: String):Array{
			
			var v:Array = new Array();
			var aux_id:int;
			var aux_date:String;
			var aux_nombre:String;
			var aux_data: String;
			var e: Ejercicio;
			
			if(this.preparada){			//	Base de datos preparada
				selectStmt = new SQLStatement();
				selectStmt.sqlConnection = conn;
				var sql:String = "SELECT * FROM ejercicios where nombre like '%" + q + "%' or info like '%" + q + "%'";
				selectStmt.text = sql;
			
				try{
					selectStmt.execute();
				}catch (error){
					trace("SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details);
					return null;
				}
				result = selectStmt.getResult();
				if(result.data != null){
					var numRows:int = result.data.length;
					for (var i:int = 0; i < numRows; i++){
						e = new Ejercicio(	result.data[i]["id_ejercicio"],
											result.data[i]["nombre"],
											result.data[i]["info"],
											result.data[i]["fecha"],
											result.data[i]["tipo"],
											result.data[i]["deporte"],0);
						v[i] = e;
					}				
					return v;
				}else{
					return new Array();
				}
			}else{
				return new Array();
			}
		}
		
		
		/*
		 *	Escritura de un ejercicio completo de manera transaccional, 
		 *	si se ha producido algún error se hace rollback
		 */
				
		public function escribe_ejercicio_completo(ej:Ejercicio){
			
			var i,j,k,l: int;
			k = 0;
			var sql:String = "";
			var escena: Escena;
			var mov: Movimiento;
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			ej.imprime_ejercicio();
			try{
				conn.begin();
				//Se inserta el ejercicio como tal
				sql += "INSERT INTO ejercicios (id_ejercicio, nombre, fecha, info, tipo, deporte,terreno) ";
				sql += "VALUES ('" + ej.id + "','" + ej.get_nombre() + "', '" + ej.get_fecha();
				sql += "', '" + ej.get_info() + "'," + ej.get_tipo() + ",'"+ ej.get_deporte() + "',0)";
				trace(sql);	insertStmt.text = sql;	insertStmt.execute();
				
				for(i=1; i < ej.num_escenas() ;i++){
					escena = ej.get_escena(i);
					sql  = "insert into escena (id_escena, id_ejercicio, duracion, texto, tipo, audio)";
					sql += "values ('" + escena.get_id() + "','" + ej.id + "'," + escena.duracion;
					sql += ",'" + escena.get_texto() + "', " + escena.tipo + ",'"+escena.audio+"')";
					trace(sql);	insertStmt.text = sql;	insertStmt.execute();
					for(j=0; j<escena.num_movimientos();j++){
						mov = escena.get_movimiento(j);
						sql  = "insert into movimiento (id_ejercicio, id_escena,id_movimiento, tipo, x_inicio, y_inicio , x_fin, "
						sql += "y_fin, elemento, etiqueta, rotacion)";
						sql += " values ('" + ej.id + "', '" + escena.get_id() + "', '" + k + "' , " + mov.get_tipo();
						sql += ", " + mov.get_x_ini() +", " + + mov.get_y_ini() +", ";
						sql += mov.get_x_fin() +", "+ mov.get_y_fin() +"," + mov.get_elemento() +", '";
						sql += mov.get_etiqueta() + "', " + mov.get_rotacion() + ")";
						insertStmt.text = sql;	insertStmt.execute();/*trace(sql);*/	
						
						//	Hay que introducir trayectoria?
						if(mov.get_trayectorias().length > 0){
							for(l=0; l < mov.get_trayectorias().length; l++){
								sql  = "insert into trayectoria(id_ejercicio, id_escena, id_movimiento, x, y) values (";
								sql += "'"+ ej.id + "', '" + escena.get_id() + "', '" + k + "' , " + mov.get_trayectoria(l).x;
								sql += " , " + mov.get_trayectoria(l).y + ")";trace(sql);
								insertStmt.text = sql;	insertStmt.execute();
							}
						}
						k++;
						//mov.escribe_movimiento();
					}
				}
				conn.commit();
			}catch(error: SQLError){
				trace(error);
				conn.rollback();
			}	
		}
		
		//update pool set modificado = 'j'
		public function pool(tipo: String, cadena: String){
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "update pool set modificado = '" + tipo + "', data = '"+ cadena + "'";
			texto.texto = insertStmt.text + "   " + file;
			insertStmt.execute();
			texto.texto = "insertado";
		}
		
		public function estado_pool(): String{
			
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = "select modificado from pool";
			try{
				selectStmt.execute();
			}catch (error){
				trace("SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details);
				return "error";
			}
			result = selectStmt.getResult();
			return result.data[0].modificado;
		}
		
		public function sustituye_ejercicio(ej: Ejercicio){
			elimina_ejercicio(ej.id);
			escribe_ejercicio_completo(ej);
		}
		
		public function elimina_ejercicio(id: String){

			var sql:String = "";
			
			deleteStmt = new SQLStatement();
			deleteStmt.sqlConnection = conn;
			try{
				conn.begin();
				sql = "delete from ejercicios where id_ejercicio = '" + id +"'";
				deleteStmt.text = sql;	deleteStmt.execute();
				sql = "delete from escena where id_ejercicio = '" + id + "'";
				deleteStmt.text = sql;	deleteStmt.execute();
				sql = "delete from movimiento where id_ejercicio = '" + id + "'";
				deleteStmt.text = sql;	deleteStmt.execute();
				sql = "delete from trayectoria where id_ejercicio = '" + id + "'";
				deleteStmt.text = sql;	deleteStmt.execute();
				conn.commit();
			}catch(error: SQLError){
				trace(error);
				conn.rollback();
			}
		}
		
		public function creaEjercicios():void{
			
			trace("Creando ejercicios");
			createStmt = new SQLStatement();
			createStmt.sqlConnection = conn;
			var sql:String = "";
			
			sql += "CREATE TABLE IF NOT EXISTS ejercicios (";
			sql += "	id_ejercicio	INTEGER PRIMARY KEY AUTOINCREMENT,";
			sql += "	nombre	TEXT,";
			sql += "	fecha	TEXT,";
			sql += "	info	TEXT";
			sql += ")";
			createStmt.text = sql;
			createStmt.execute();
		}

		
		public function inserta_ejercicio_par(nombre:String, fecha:String, info:String):Boolean{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			var sql:String = "";
			sql += "INSERT INTO ejercicios (nombre, fecha, info) ";
			sql += "VALUES ('" + nombre + "', '" + fecha + "', '" + info + "')";
			insertStmt.text = sql;
			insertStmt.execute();
			return true;
		}

		public function inserta_ejercicio(e:Ejercicio):Boolean{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			var sql:String = "";
			sql += "INSERT INTO ejercicios (nombre, fecha, info) ";
			sql += "VALUES ('" + e.get_nombre() + "', '" + e.get_fecha() + "', '" + e.get_info() + "')";
			insertStmt.text = sql;
			insertStmt.execute();
			return true;
		}
		
		
		public function nuevo_jugador(id:String, nombre: String, url: String){
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			var sql:String = "";
			sql += "INSERT INTO jugadores (id_jugador, nombre, url) ";
			sql += "VALUES ('" + id + "', '" + nombre + "', '" + url + "')";
			insertStmt.text = sql;
			insertStmt.execute();
			return true;
		}
		
		
		//////////IMPORTACIONES
		
		public function inserta_deporte(deporte: String):void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "insert into deporte(Nombre) values( '" + deporte + "')";
			insertStmt.execute();
		}
		
		public function inserta_elemento(el: ElementoBE):void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "insert into elemento (id_elemento, nombre, tipo, imagen, altura, anchura )";
			insertStmt.text += " values(" + el.id + ", '" + el.nombre  + "','"+ el.tipo+"','"+el.imagen+"',"+el.altura+","+el.anchura+")";
			insertStmt.execute();
		}
		
		public function inserta_fondo(f: Fondo):void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "insert into fondo (id_fondo, nombre, imagen, altura, anchura, m_alto, m_ancho )";
			insertStmt.text += " values(" + f.id + ", '" + f.nombre  + "','"+ f.url +"',"+f.altura+","+ f.anchura+ ","+f.altura_m+","+f.anchura_m+")";
			insertStmt.execute();
		}
		
		public function inserta_relacion_elemento(dep: String, elem: int):void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "insert into tiene_elementos (deporte, id_elemento)";
			insertStmt.text += " values('" + dep + "', " + elem + ")";
			insertStmt.execute();
		}
		
		public function inserta_relacion_fondo(dep: String, fondo: int):void{
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text = "insert into tiene_fondos (Deporte, id_fondo)";
			insertStmt.text += " values('" + dep + "', " + fondo + ")";
			insertStmt.execute();
		}
		
		
		/*
		 *		DEBUG
		 */
		public function addDataExer():void{
			
			trace("insertando ejercicios de muestra");
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			var sql:String = "";
			sql += "INSERT INTO ejercicios (nombre, fecha, info) ";
			sql += "VALUES ('Ejericicio 1', '10/10/2010', 'Informacion del ejercicio 1')";
			insertStmt.text = sql;
			
			//insertStmt.addEventListener(SQLEvent.RESULT, insertResult);
			//insertStmt.addEventListener(SQLErrorEvent.ERROR, insertError);
			insertStmt.execute();
			
			sql = "INSERT INTO ejercicios (nombre, fecha, info) ";
			sql += "VALUES ('Ejericicio 2', '20/02/2012', 'Informacion del ejercicio 2')";
			insertStmt.text = sql;
			//insertStmt.addEventListener(SQLEvent.RESULT, insertResult);
			//insertStmt.addEventListener(SQLErrorEvent.ERROR, insertError);
			insertStmt.execute();
			
		}
		
		/*function createResult(event:SQLEvent):void
		{
			createStmt.removeEventListener(SQLEvent.RESULT, createResult);
			createStmt.removeEventListener(SQLErrorEvent.ERROR, createError);
			
			addData();
		}
		
		function createError(event:SQLErrorEvent):void
		{
			//status.text = "Error creating table";
			
			createStmt.removeEventListener(SQLEvent.RESULT, createResult);
			createStmt.removeEventListener(SQLErrorEvent.ERROR, createError);
			
			trace("CREATE TABLE error:", event.error);
			trace("event.error.message:", event.error.message);
			trace("event.error.details:", event.error.details);
		}
		
		
		function addData():void
		{
			//status.text = "Adding data to table";
			
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			var sql:String = "";
			sql += "INSERT INTO employees (firstName, lastName, salary) ";
			sql += "VALUES ('Bob', 'Smith', 8000)";
			insertStmt.text = sql;
			
			insertStmt.addEventListener(SQLEvent.RESULT, insertResult);
			insertStmt.addEventListener(SQLErrorEvent.ERROR, insertError);
			
			insertStmt.execute();
			
			insertStmt2 = new SQLStatement();
			insertStmt2.sqlConnection = conn;
			var sql2:String = "";
			sql2 += "INSERT INTO employees (firstName, lastName, salary) ";
			sql2 += "VALUES ('John', 'Jones', 8200)";
			insertStmt2.text = sql2;
			
			insertStmt2.addEventListener(SQLEvent.RESULT, insertResult);
			insertStmt2.addEventListener(SQLErrorEvent.ERROR, insertError);
			
			insertStmt2.execute();
		}
		
		function insertResult(event:SQLEvent):void
		{
			var stmt:SQLStatement = event.target as SQLStatement;
			stmt.removeEventListener(SQLEvent.RESULT, insertResult);
			stmt.removeEventListener(SQLErrorEvent.ERROR, insertError);
			
			if (stmt == insertStmt)
			{
				insert1Complete = true;
			}
			else
			{
				insert2Complete = true;
			}
			
			if (insert1Complete && insert2Complete)
			{
				//status.text = "Ready to load data";
			}
		}
		
		function insertError(event:SQLErrorEvent):void
		{
			//status.text = "Error inserting data";
			
			insertStmt.removeEventListener(SQLEvent.RESULT, insertResult);
			insertStmt.removeEventListener(SQLErrorEvent.ERROR, insertError);
			
			trace("INSERT error:", event.error);
			trace("event.error.message:", event.error.message);
			trace("event.error.details:", event.error.details);
		}
		
		
		function getData(event:MouseEvent):void
		{
			//status.text = "Loading data";
			
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			var sql:String = "SELECT empId, firstName, lastName, salary FROM employees";
			selectStmt.text = sql;
			
			selectStmt.addEventListener(SQLEvent.RESULT, selectResult);
			selectStmt.addEventListener(SQLErrorEvent.ERROR, selectError);
			
			selectStmt.execute();
		}
		
		function selectResult(event:SQLEvent):void
		{
			//status.text = "Data loaded";
			
			selectStmt.removeEventListener(SQLEvent.RESULT, selectResult);
			selectStmt.removeEventListener(SQLErrorEvent.ERROR, selectError);
			
			var result:SQLResult = selectStmt.getResult();
			
			//resultsGrid.dataProvider = new DataProvider(result.data);
			
			var numRows:int = result.data.length;
			for (var i:int = 0; i < numRows; i++)
			{
				var output:String = "";
				for (var prop:String in result.data[i])
				{
					output += prop + ": " + result.data[i][prop] + "; ";
				}
				trace("row[" + i.toString() + "]\t", output);
			}				
		}
		
		function selectError(event:SQLErrorEvent):void
		{
			//status.text = "Error loading data";
			
			selectStmt.removeEventListener(SQLEvent.RESULT, selectResult);
			selectStmt.removeEventListener(SQLErrorEvent.ERROR, selectError);
			
			trace("SELECT error:", event.error);
			trace("event.error.message:", event.error.message);
			trace("event.error.details:", event.error.details);
		}*/
		
		public function getFile():String{
			return file;
		}
		
		/*
		 * 	<DIBUJO LIBRE>
		 */
		
		public function escribeDibujoLibre(dibujo: DibujoLibre) {
			
			//	Existe el dibujo?
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = "select Id from DibujosLibres where Id='" + dibujo.id + "'";
			try{
				selectStmt.execute();
			}catch (error){
				return "SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details;
			}
			result = selectStmt.getResult();
			//	Hay resultados?
			if(!result.data){
			//	Inserta
				return insertaDibujoLibre(dibujo);
			}else {
			//	Actualiza
				return updateDibujoLibre(dibujo);
			}
		}
		
		public function insertaDibujoLibre(dibujo: DibujoLibre): String {
			
			var i: int = 1;		//	Contador de trazo
			var fecha: Date = new Date();
			
			conn.begin();
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			//	Insert Dibujo Base
			
			insertStmt.text = "insert into DibujosLibres (Id, Titulo, Info, FechaCreacion, FechaModificacion, Fondo, Deporte)";
			insertStmt.text += " values( @dibujo_id , @dibujo_titulo, @Info, '" + dibujo.fechaCreacion + "', '" + dibujo.fechaModificacion + "', @Fondo, @Deporte )";
			insertStmt.parameters["@dibujo_id"] = dibujo.id;
			insertStmt.parameters["@dibujo_titulo"] = dibujo.titulo;
			insertStmt.parameters["@Info"] = dibujo.info;
			insertStmt.parameters["@Fondo"] = dibujo.fondo;
			insertStmt.parameters["@Deporte"] = dibujo.deporte;
			trace("deporte " + dibujo.deporte);
			//Util.subTrace("SQL: " + insertStmt.text);
			try {	
				insertStmt.execute();
				writePoints(dibujo.trazos, dibujo.id);	//	Write points
				writeElements(dibujo);		//	Write Elements
			}
			catch (error: SQLError) {
				conn.rollback();
				return error.message + " " + error.details;
			}

			conn.commit();
			return "Dibujo Insertado correctamente";	
		}
		
		public function updateDibujoLibre(dibujo: DibujoLibre): String {
			
			var i: int = 1;		//	Contador de trazo
			var fecha: Date = new Date;
			
			conn.begin();
			updateStmt = new SQLStatement();
			updateStmt.sqlConnection = conn;
			updateStmt.text =  "update DibujosLibres "
			updateStmt.text += "set Titulo = '" + dibujo.titulo + "', ";
			updateStmt.text += "Info = '" + dibujo.info + "', ";
			updateStmt.text += "FechaModificacion = '" + dibujo.fechaModificacion + "' ";
			updateStmt.text += "where Id = @id ";
			updateStmt.parameters["@id"] = dibujo.id;
			//Util.subTrace("SQL: " + updateStmt.text);
			try {	
				updateStmt.execute();
				//	Delete first
				deletePoints(dibujo.id);
				deleteElementsInFree(dibujo.id);
				//	Write 
				writePoints(dibujo.trazos, dibujo.id);
				writeElements(dibujo);
			}
			catch (error: SQLError) {
				conn.rollback();
				return error.message + " " + error.details;
			}	
			conn.commit();
			return "Dibujo Actualizado correctamente";
		}

		public function deleteElementsInFree(idDibujo: String) {
			
			var i: int = 1;		//	Contador de secuencia
			deleteStmt = new SQLStatement();
			deleteStmt.sqlConnection = conn;
			deleteStmt.text =  "delete from ElementosDibujoLibre ";
			deleteStmt.text += "where IdDibujo = '" + idDibujo + "'";
			deleteStmt.execute();
		}
		
		public function deletePoints(idDibujo: String) {
			
			var i: int = 1;		//	Contador de secuencia
			deleteStmt = new SQLStatement();
			deleteStmt.sqlConnection = conn;
			deleteStmt.text =  "delete from PuntosDibujoLibre ";
			deleteStmt.text += "where IdDibujo = '" + idDibujo + "'";
			deleteStmt.execute();
		}
		
		public function writePoints(trazos: Array, id: String) {
			var i: int = 1;
			for each(var t: Trazo in trazos) {
				insertaPuntoEnDibujo(t.puntos, id, i);
				i++;
			}
		}
		
		public function writeElements(dibujo: DibujoLibre) {
			for each(var id: String in dibujo.idsElementos) {
				insertaElementoEnDibujo(dibujo, id);
			}
		}
		
		public function insertaPuntoEnDibujo(trazo: Array, idDibujo: String, nTrazo: int) {
			
			var i: int = 1;		//	Contador de secuencia
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			for each(var p: Point in trazo){
				//	Insert Point
				insertStmt.text =  "insert into PuntosDibujoLibre (IdDibujo, trazo, secuencia, x, y) ";
				insertStmt.text += "values('" + idDibujo + "', " + nTrazo + " , " + i + ", ";
				insertStmt.text += p.x + " , " + p.y + ")";
				insertStmt.execute();
				i++;
			}
		}
		
		public function insertaElementoEnDibujo(dibujo: DibujoLibre, idElemento: String) {
			
			var i: int = 1;		//	Contador de secuencia
			//var id: String = dibujo.idsElementos[idElemento];
			insertStmt = new SQLStatement();
			insertStmt.sqlConnection = conn;
			insertStmt.text =  "insert into ElementosDibujoLibre (IdDibujo, IdElemento, IdTipoElemento, x, y) ";
			insertStmt.text += "values( @id, @IdElemento, @IdTipo, @x, @y )";
			insertStmt.parameters["@id"] = dibujo.id;
			insertStmt.parameters["@IdElemento"] = idElemento;
			insertStmt.parameters["@IdTipo"] = dibujo.elementos[idElemento];
			insertStmt.parameters["@x"] = dibujo.estados[idElemento].posicion.x;
			insertStmt.parameters["@y"] = dibujo.estados[idElemento].posicion.y;
			//insertStmt.text += dibujo.estados[idElemento].posicion.x + " , " + dibujo.estados[idElemento].posicion.y + ")";
			insertStmt.execute();
		}
		
		public function deleteDibujoLibre(id: String) {
			
			//	Borra el dibujo Libre
			conn.begin();
			try {
				deleteElementsInFree(id);
				deletePoints(id);
				deleteStmt = new SQLStatement();
				deleteStmt.sqlConnection = conn;
				deleteStmt.text =  "delete from DibujosLibres ";
				deleteStmt.text += "where Id = '" + id + "'";
				deleteStmt.execute();
				conn.commit();
			}catch (error) {
				conn.rollback();
				trace("Error :"+ error.message +" Details: "+ error.details);
				return "Error :"+ error.message +" Details: "+ error.details;
			}
		}
		
		public function lee_dibujosLibres(): Array {
			
			var dibujos: Array = new Array();
			var auxDibujo: DibujoLibre = new DibujoLibre();
			
			//	Lee el dibujo
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = "select * from DibujosLibres";
			try{
				selectStmt.execute();
				result = selectStmt.getResult();
				if (result.data) {	//	Tenemos datos
					for each(var row: Object in result.data ) {
						auxDibujo = new DibujoLibre();
						auxDibujo.titulo = row.Titulo;
						auxDibujo.id = row.Id;
						auxDibujo.fechaCreacion = row.FechaCreacion;
						auxDibujo.fechaModificacion = row.FechaModificacion;
						auxDibujo.fondo = row["Fondo"];
						auxDibujo.deporte = row["Deporte"];
						if (row["Info"] == null) {
							auxDibujo.info = "";
						}else {
							auxDibujo.info = row["Info"];
						}
						
						//	Lee los trazos
						leeTrazosDibujoLibre(auxDibujo);
						//	Lee los elementos
						leeElementosDibujoLibre(auxDibujo);
						dibujos.push(auxDibujo);
					}
				}
			}catch (error){
				trace("Error :" + error.message +" Details: " + error.details);			
			}
			return dibujos;
		}
		
		public function leeElementosDibujoLibre(dibujo: DibujoLibre) {
			
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = "select * from ElementosDibujoLibre ";
			selectStmt.text += "where IdDibujo = '" + dibujo.id + "'";
			//selectStmt.parameters["@id"] = dibujo.id; 
			selectStmt.execute();
			result = selectStmt.getResult();
			if (result.data) {	//	Tenemos datos
				for each(var row: Object in result.data ) {
					var estado: Estado = new Estado(new Point(row.x, row.y), 0);
					dibujo.addElemento(row.IdElemento, row.IdTipoElemento, estado);
				}
			}
		}
		
		public function leeTrazosDibujoLibre(dibujo: DibujoLibre) {
			var nTrazo: int = 0;
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = "select * from PuntosDibujoLibre ";
			selectStmt.text += "where IdDibujo = @id ";
			selectStmt.text += "order by trazo, secuencia"
			selectStmt.parameters["@id"] = dibujo.id; 
			selectStmt.execute();
			result = selectStmt.getResult();
			if (result.data) {	//	Tenemos datos
				for each(var row: Object in result.data ) {
					if (row.trazo != nTrazo) {	//	Nuevo trazo
						dibujo.newTrazo();
						nTrazo = row.trazo;
					}
					dibujo.ultimoTrazo.add(new Point(row.x, row.y));
				}
			}
		}
		
		public function filtraDibujosLibres(query: String): Array {
			
			var dibujos: Array = new Array();
			var auxDibujo: DibujoLibre = new DibujoLibre();
			
			//	Lee el dibujo
			selectStmt = new SQLStatement();
			selectStmt.sqlConnection = conn;
			selectStmt.text = "select * from DibujosLibres ";
			selectStmt.text += "where Titulo like '%" + query + "%' OR ";
			selectStmt.text += "Info like '%" + query + "%'";
			try{
				selectStmt.execute();
				result = selectStmt.getResult();
				if (result.data) {	//	Tenemos datos
					for each(var row: Object in result.data ) {
						auxDibujo = new DibujoLibre();
						auxDibujo.titulo = row.Titulo;
						auxDibujo.id = row.Id;
						auxDibujo.fechaCreacion = row.FechaCreacion;
						auxDibujo.fechaModificacion = row.FechaModificacion;
						auxDibujo.fondo = row["Fondo"];
						auxDibujo.deporte = row["Deporte"];
						auxDibujo.info = row["Info"];
						//	Lee los trazos
						leeTrazosDibujoLibre(auxDibujo);
						//	Lee los elementos
						leeElementosDibujoLibre(auxDibujo);
						dibujos.push(auxDibujo);
					}
				}
			}catch (error){
				trace("Error :" + error.message +" Details: " + error.details);			
			}
			return dibujos;
		}
		/*
		 * 	</DIBUJO LIBRE>
		 */
		
		public function get conexion(): SQLConnection { return conn; }
	}
}
