﻿package org.pizarra.DAL {	
	
	import flash.data.SQLConnection;
	import flash.data.SQLStatement;
	import flash.data.SQLResult;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	import org.pizarra.Entity.*;
	import org.pizarra.util.*;
	import org.pizarra.Util;
	import org.pizarra.configuracion.Tema;
	
	public class TemaDA{
		
		private var con: SQLConnection;
		private var result:SQLResult;
		private var temaEntity: TemaBE = new TemaBE();
		
		public function TemaDA(bdRef: SQLConnection) {
			con = bdRef;
		}
		
		public function escribe(tema: TemaBE):String {
			try {
				con.begin();
				
				if (!existeTema(tema.id)) {
					insertaTema(tema);
				}else {
					con.rollback();
					Util.subTrace("El Tema ya existe.");
					return "El tema ya existe";
				}
			}catch (error) {
				con.rollback();
				Util.subTrace("Error :"+ error.message +" Details: "+ error.details);
				return "Error :"+ error.message +" Details: "+ error.details;
			}
			con.commit();
			return "";	//	Can't reach that point
		}
		
		//	Write the theme
		private function insertaTema(tema: TemaBE) {
			
			temaEntity = tema;
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			insertStmt.text =  " insert into " + DBConstants.T_TEMAS;
			insertStmt.text += " (Id, Name, IdUsuario, backgroundA, backgroundB, ";
			insertStmt.text += " secondBgA, secondBgB,secondBorderColor, secondBorderWidth, spanBgA, spanBgB,  "; 
			insertStmt.text += " spanBorderColor, spanBorderWidth) ";
			insertStmt.text += " values( @Id, @Name, @IdUsuario, @backgroundA, @backgroundB, ";
			insertStmt.text += " @secondBgA, @secondBgB, @secondBorderColor, @secondBorderWidth, @spanBgA, @spanBgB, ";
			insertStmt.text += " @spanBorderColor, @spanBorderWidth)";
			insertStmt.parameters["@Id"] = tema.id; 
			insertStmt.parameters["@Name"] = tema.name; 
			insertStmt.parameters["@IdUsuario"] = Constantes.USUARIO;
			insertStmt.parameters["@backgroundA"] = tema.backgroundA;
			insertStmt.parameters["@backgroundB"] = tema.backgroundB;  
			insertStmt.parameters["@secondBgA"] = tema.secondBgA; 
			insertStmt.parameters["@secondBgB"] = tema.secondBgB;  
			insertStmt.parameters["@secondBorderColor"] =  tema.secondBorderColor; 
			insertStmt.parameters["@secondBorderWidth"] = tema.secondBorderWidth;  
			insertStmt.parameters["@spanBgA"] = tema.spanBgA;  
			insertStmt.parameters["@spanBgB"] = tema.spanBgB;  
			insertStmt.parameters["@spanBorderColor"] =  tema.spanBorderColor; 
			insertStmt.parameters["@spanBorderWidth"] = tema.spanBorderWidth;  
			//	New
			insertStmt.execute();
		}
		
		//	update the theme
		public function updateTema(tema: TemaBE) {
			temaEntity = tema;
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			insertStmt.text =  " Update " + DBConstants.T_TEMAS;
			insertStmt.text += " Set Name = @Name ";
			insertStmt.text += " ,backgroundA = @backgroundA ";
			insertStmt.text += " ,secondBgA = @secondBgA ";
			insertStmt.text += " ,SeparatorColor = @SeparatorColor ";
			insertStmt.text += " ,lblColor = @lblColor ";
			insertStmt.text += " ,lblSize = @lblSize ";
			insertStmt.text += " ,colorTitulo = @colorTitulo ";
			insertStmt.text += " ,buttonBackgroundColor = @buttonBackgroundColor ";
			insertStmt.text += " ,ButtonBackgroundPressed = @ButtonBackgroundPressed ";
			insertStmt.text += " ,buttonBorder = @buttonBorder ";
			
			insertStmt.parameters["@Name"] = tema.name; 
			insertStmt.parameters["@backgroundA"] = tema.backgroundA;
			insertStmt.parameters["@secondBgA"] = tema.secondBgA; 
			insertStmt.parameters["@SeparatorColor"] = tema.separatorColor;
			insertStmt.parameters["@lblColor"] = tema.lblColor; 
			insertStmt.parameters["@lblSize"] = tema.lblSize; 
			insertStmt.parameters["@colorTitulo"] = tema.colorTitulo; 
			insertStmt.parameters["@buttonBackgroundColor"] = tema.buttonBackgroundColor; 
			insertStmt.parameters["@ButtonBackgroundPressed"] = tema.selectedButtonBackgroundColor; 
			insertStmt.parameters["@buttonBorder"] = tema.buttonBorder; 
			insertStmt.execute();
		}
		
		public function getTemas(): Array {
			
			var temas: Array = new Array();
			var temaBE: TemaBE;
			
			var selectStmt: SQLStatement = new SQLStatement();
			try {
				selectStmt.sqlConnection = con;
				selectStmt.text =  "select Id, Name, IdUsuario, backgroundA, backgroundB, ";
				selectStmt.text += " secondBgA, secondBgB, spanBgA, spanBgB, SeparatorColor, lblSize, lblColor, "; 
				selectStmt.text += "  colorTitulo, buttonBackgroundColor, ButtonBackgroundPressed, buttonBorder";
				selectStmt.text += " from " + DBConstants.T_TEMAS;
				selectStmt.text += " order by Name";
				selectStmt.execute();
				result = selectStmt.getResult();
				for each(var row in result.data) {
					temaBE = new TemaBE();
					temaBE.id = String(row['Id']);
					temaBE.name = String(row['Name']);
					temaBE.backgroundA = uint(row['backgroundA']);
					temaBE.backgroundB = uint(row['backgroundB']);
					temaBE.secondBgA = uint(row['secondBgA']);
					temaBE.secondBgB = uint(row['secondBgB']);
					temaBE.spanBgA = uint(row['spanBgA']);
					temaBE.spanBgB = uint(row['spanBgB']);
					
					// New
					temaBE.separatorColor = uint(row['SeparatorColor']);
					temaBE.lblSize = uint(row['lblSize']);
					temaBE.lblColor = uint(row['lblColor']);
					temaBE.colorTitulo = uint(row['colorTitulo']);
					temaBE.buttonBackgroundColor = uint(row['buttonBackgroundColor']);
					temaBE.selectedButtonBackgroundColor = uint(row['ButtonBackgroundPressed']);
					temaBE.buttonBorder = uint(row['buttonBorder']);

					temas.push(temaBE);
				}
			}catch (error) {
				Util.subTrace("SELECT error:" + error + "error.message:" + error.message +"error.details:" + error.details);
			}
			return temas;
		}
		
		//	Test if the theme exists in the database
		private function existeTema(id: String): Boolean {
			
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			selectStmt.text = "select Id from "+DBConstants.T_TEMAS+" where Id = @id";
			selectStmt.parameters["@id"] = id;
			try{
				selectStmt.execute();
				result = selectStmt.getResult();
			}catch (error){
				return "SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details;
			}
			return result.data != null;
		}
		
		//	Test if the theme exists in the database
		public function deleteTema(id: String): String {
			
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			selectStmt.text = "delete from "+DBConstants.T_TEMAS+" where Id = @id";
			selectStmt.parameters["@id"] = id;
			try{
				selectStmt.execute();
				result = selectStmt.getResult();
			}catch (error){
				Util.subTrace("SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details);
				return "Error borrando tema";
			}
			return "Tema Borrado Correctamente";
		}
		
		public function get tema(): TemaBE { return temaEntity; }
	}
}