﻿package org.pizarra.DAL {	
	
	import flash.data.*;
	import flash.errors.*;
	import flash.events.*;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	import org.pizarra.Entity.*;
	import org.pizarra.util.*;
	import org.pizarra.Util;
	
	public class EjercicioDA{
		
		private var con: SQLConnection;
		private var result: SQLResult;
		
		public function EjercicioDA(bdRef: SQLConnection) {
			con = bdRef;
		}
		
		public function writeExercise(ej:EjercicioBE):String {
			
			con.begin();
			trace("begin");
			if (!exerciseExists(ej.id)) {
				if (insertExercise(ej)) {
					con.commit();
					trace("commit");
					return "Ejercicio Insertado correctamente";
				}
			}else {
				if (updateExercise(ej)) {
					con.commit();
					trace("commit");
					return "Ejercicio Actualizado correctamente";
				}
			}
			trace("rollback");
			con.rollback();
			return "Error Actualizando ejercicio";
		}
		
		//	Write the exercise
		public function insertExercise(ej: EjercicioBE):Boolean {
			trace("Insert exercise");
			var t: Date = new Date();
			var insertStmt: SQLStatement = new SQLStatement();
			try 
			{
				insertStmt.sqlConnection = con;
				insertStmt.text =  " insert into " + DBConstants.T_EJERCICIOS;
				insertStmt.text += " (Id, Nombre, Info, IdDeporte, IdFondo, ";
				insertStmt.text += " IdTipoEjercicio, FechaCreacion, FechaModificacion )"; 
				insertStmt.text += " values( @Id, @Nombre, @Info, @IdDeporte, @IdFondo, ";
				insertStmt.text += " @IdTipoEjercicio, @FechaCreacion, @FechaModificacion) ";
				insertStmt.parameters["@Id"] = ej.id; 
				insertStmt.parameters["@Nombre"] = ej.nombre; 
				insertStmt.parameters["@Info"] = ej.info;
				insertStmt.parameters["@IdDeporte"] = ej.deporte;
				insertStmt.parameters["@IdFondo"] = ej.fondo;
				insertStmt.parameters["@IdTipoEjercicio"] = ej.tipo;
				insertStmt.parameters["@FechaCreacion"] = ej.fechaCreacion;
				insertStmt.parameters["@FechaModificacion"] = t;
				insertStmt.execute();
				if(!insertEscenas(ej.escenas)) return false;
			}catch (error) {
				Util.subTrace(error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
				return false;
			}
			return true;
		}
		
		public function updateExercise(ej: EjercicioBE):Boolean {
			//	Remove exercise
			try {
				trace("Update exercise");
				if(!removeExercise(ej)) return false;
				if(!insertExercise(ej)) return false;
			}catch (error) {
				return false;
			}
			return true;
		}
		
		//	Delete exercise
		public function removeExercise(ej: EjercicioBE): Boolean {
			try{
				var deleteStmt = new SQLStatement();
				deleteStmt.sqlConnection = con;				
				deleteStmt.text =  "delete from " + DBConstants.T_EJERCICIOS;
				deleteStmt.text += " where Id = '" + ej.id + "'";
				deleteStmt.execute();
				deleteStmt.text =  "delete from " + DBConstants.T_ESCENAS;
				deleteStmt.text += " where IdEjercicio = '" + ej.id + "'";
				deleteStmt.execute();
				//	For every scene delete movements
				for each(var esc: EscenaBE in ej.escenas){
					deleteStmt.text =  "delete from " + DBConstants.T_MOVIMIENTOS;
					deleteStmt.text += " where IdEscena = '" + esc.id + "'";
					deleteStmt.execute();
					for each(var mov: MovimientoBE in esc.movimientos) {
						deleteStmt.text =  "delete from " + DBConstants.T_TRAYECTORIAS;
						deleteStmt.text += " where IdMovimiento = '" + mov.id + "'";
						deleteStmt.execute();
					}
				}
			}catch (error) {
				Util.subTrace("Error :"+ error.message +" Details: "+ error.details);
				return false;
			}
			return true;
		}
		
		//	Test if the exercise exists in the database
		private function exerciseExists(id: String): Boolean {
			
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			selectStmt.text = "select Id from "+DBConstants.T_EJERCICIOS+" where Id = @id";
			selectStmt.parameters["@id"] = id;
			try{
				selectStmt.execute();
				result = selectStmt.getResult();
			}catch (error) {
				Util.subTrace(error.getStackTrace + "error.message:"+ error.message +"error.details:"+ error.details);
				return false;
			}
			return result.data != null;
		}
		
		//	ESCENAS
		private function insertEscenas(escenas: Array): Boolean {
			
			var insertStmt: SQLStatement = new SQLStatement();
			try 
			{
				for (var i: int = 1; i < escenas.length; i++ ) {
					
					var esc: EscenaBE = escenas[i];
					insertStmt.sqlConnection = con;
					insertStmt.text =  " insert into " + DBConstants.T_ESCENAS;
					insertStmt.text += " (Id, IdEjercicio, IdTipoEscena, Orden, Duracion, ";
					insertStmt.text += " Audio, Texto )"; 
					insertStmt.text += " values( @Id, @IdEjercicio, @IdTipoEscena, @Orden, @Duracion, ";
					insertStmt.text += " @Audio, @Texto ) ";
					insertStmt.parameters["@Id"] = esc.id; 
					insertStmt.parameters["@IdEjercicio"] = esc.ejercicio; 
					insertStmt.parameters["@IdTipoEscena"] = esc.tipo;
					insertStmt.parameters["@Orden"] = esc.orden;
					insertStmt.parameters["@Duracion"] = esc.duracion;
					insertStmt.parameters["@Audio"] = esc.audio;
					insertStmt.parameters["@Texto"] = esc.texto;
					insertStmt.execute();
					if(!insertMovimientos(esc.movimientos)) return false;
				}
			}catch (error) {
				Util.subTrace("Error insertando escena: " + error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
				return  false;
			}
			return true;
		}
		
		//	MOVIMIENTOS
		private function insertMovimientos(movimientos: Array): Boolean {
			
			var insertStmt: SQLStatement = new SQLStatement();
			try {
				trace("len " + movimientos.length);
				for (var i: int = 0; i < movimientos.length; i++ ) {
					var mov: MovimientoBE = movimientos[i];
					trace("Escribe movimiento :" + mov.id);
					insertStmt.sqlConnection = con;
					insertStmt.text =  " insert into " + DBConstants.T_MOVIMIENTOS;
					insertStmt.text += " (Id, IdEscena, IdElemento, IdTipoMovimiento, IdAccion, PreAccionId, PostAccionId, ";
					insertStmt.text += " Orden, XInicio, YInicio, Rotacion, Etiqueta )"; 
					insertStmt.text += " values( @Id, @IdEscena, @IdElemento, @IdTipoMovimiento, @IdAccion, @PreAccionId, @PostAccionId, ";
					insertStmt.text += " @Orden, @XInicio, @YInicio, @Rotacion, @Etiqueta ) ";
					insertStmt.parameters["@Id"] = mov.id; 
					insertStmt.parameters["@IdEscena"] = mov.escena; 
					insertStmt.parameters["@IdElemento"] = mov.elemento; 
					insertStmt.parameters["@IdTipoMovimiento"] = mov.tipo; 
					insertStmt.parameters["@IdAccion"] = mov.accion; 
					insertStmt.parameters["@PreAccionId"] = mov.preAccion; 
					insertStmt.parameters["@PostAccionId"] = mov.postAccion; 
					insertStmt.parameters["@Orden"] = mov.orden; 
					insertStmt.parameters["@XInicio"] = mov.inicio.x; 
					insertStmt.parameters["@YInicio"] = mov.inicio.y; 
					insertStmt.parameters["@Rotacion"] = mov.rotacion; 
					insertStmt.parameters["@Etiqueta"] = mov.etiqueta; 
					insertStmt.execute();
					if(!insertTrayectoria(mov.trayectoria)) return false;
				}
			}catch (error) {
				Util.subTrace("Error insertando Movimiento: " + error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
				return  false;
			}
			return true;
		}
		
		//	TRAYECTORIA
		private function insertTrayectoria(trayectoria: Array): Boolean {
			
			var insertStmt: SQLStatement = new SQLStatement();
			try {
				for (var i: int = 0; i < trayectoria.length; i++ ) {
					var tray: TrayectoriaBE = trayectoria[i];
					insertStmt.sqlConnection = con;
					insertStmt.text =  " insert into " + DBConstants.T_TRAYECTORIAS;
					insertStmt.text += " (IdMovimiento, Orden, X, Y )";
					insertStmt.text += " values( @IdMovimiento, @Orden, @X, @Y ) ";
					insertStmt.parameters["@IdMovimiento"] = tray.movimiento; 
					insertStmt.parameters["@Orden"] = tray.orden; 
					insertStmt.parameters["@X"] = tray.punto.x; 
					insertStmt.parameters["@Y"] = tray.punto.y; 
					insertStmt.execute();
				}
			}catch (error) {
				Util.subTrace("Error insertando Trayectoria: " + error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
				return  false;
			}
			return true;
		}
		
		//	SELECT EJERCICIOS
		public function selectEjercicios():Array{
			
			var ejercicios :Array = new Array();
			
			try {
				var selectStmt: SQLStatement = new SQLStatement();
				selectStmt.sqlConnection = con;
				selectStmt.text  = " select Id, Nombre, Info, IdDeporte, IdFondo, ";
				selectStmt.text += " IdTipoEjercicio, FechaCreacion, FechaModificacion ";
				selectStmt.text += " from " + DBConstants.T_EJERCICIOS;
				selectStmt.execute();
				var result: SQLResult = selectStmt.getResult();
				if (result.data != null) {
					var ii: int = result.data.length;
					for (var i:int = 0; i < ii; i++) {
						var e: EjercicioBE = new EjercicioBE();	
						e.id = result.data[i]["Id"];
						e.nombre = result.data[i]["Nombre"];
						e.info = result.data[i]["Info"];
						e.deporte = result.data[i]["IdDeporte"];
						e.fondo = result.data[i]["IdFondo"];
						e.tipo = result.data[i]["IdTipoEjercicio"];
						e.fechaCreacion = result.data[i]["FechaCreacion"];
						e.fechaModificacion = result.data[i]["FechaModificacion"];
						e.escenas = selectEscenas(e.id);
						ejercicios.push(e);
					}				
				}
			}catch (error){
				Util.subTrace("Error lectura Ejercicio:" + error.getStackTrace() + "error.message:"+ error.message +"error.details:"+ error.details);
			}	
			return ejercicios;
		}
		
		public function selectEscenas(idEjercicio: String):Array{
			
			var escenas: Array = new Array();
			try {
				var selectStmt: SQLStatement = new SQLStatement();
				selectStmt.sqlConnection = con;
				selectStmt.text = " select Id, IdEjercicio, IdTipoEscena, Orden, Duracion, ";
				selectStmt.text += " Audio, Texto from " + DBConstants.T_ESCENAS;
				selectStmt.text += " where IdEjercicio = @IdEjercicio ";
				selectStmt.text += " order by Orden";
				selectStmt.parameters["@IdEjercicio"] = idEjercicio; 
				selectStmt.execute();
				var result: SQLResult = selectStmt.getResult();
				if(result.data != null){
					for (var i:int = 0; i < result.data.length; i++){
						var es: EscenaBE = new EscenaBE();	
						es.id = result.data[i]["Id"];
						es.ejercicio = result.data[i]["IdEjercicio"];
						es.tipo = result.data[i]["IdTipoEscena"];
						es.orden = result.data[i]["Orden"];
						es.duracion = result.data[i]["Duracion"];
						es.audio = result.data[i]["Audio"];
						es.texto = result.data[i]["Texto"];
						es.movimientos = selectMovimientos(es.id);
						//trace("i " + (i + 1) + " " + es.id + " - " + es.audio);
						escenas[i+1] = es;
					}				
				}
			}catch (error) {
				trace("error");
				Util.subTrace("Error lectura Ejercicio:" + error.getStackTrace() + "error.message:"+ error.message +"error.details:"+ error.details);
			}	
			return escenas;
		}
		
		public function selectMovimientos(idEscena: String):Array{
			
			var movimientos: Array = new Array();
			try {
				var selectStmt: SQLStatement = new SQLStatement();
				selectStmt.sqlConnection = con;
				selectStmt.text = " select Id, IdElemento,IdTipoMovimiento, Orden, IdAccion,XInicio, YInicio, Rotacion, Etiqueta ";
				selectStmt.text += " from " + DBConstants.T_MOVIMIENTOS;
				selectStmt.text += " where IdEscena = @IdEscena ";
				selectStmt.text += " order by Orden";
				selectStmt.parameters["@IdEscena"] = idEscena; 
				selectStmt.execute();
				
				var result: SQLResult = selectStmt.getResult();
				
				if(result.data != null){
					for (var i:int = 0; i < result.data.length; i++){
						var mov: MovimientoBE = new MovimientoBE();	
						mov.id = result.data[i]["Id"];
						mov.accion = result.data[i]["IdAccion"];
						mov.elemento = result.data[i]["IdElemento"];
						mov.escena = idEscena;
						mov.etiqueta = result.data[i]["Etiqueta"];
						mov.inicio = new Point(result.data[i]["XInicio"],result.data[i]["YInicio"]);
						mov.orden = result.data[i]["Orden"];
						mov.rotacion = result.data[i]["Rotacion"];
						mov.tipo = result.data[i]["IdTipoMovimiento"];
						mov.trayectoria = selectTrayectoria(mov.id);
						movimientos[i] = mov;
					}				
				}
			}catch (error) {
				trace("error");
				Util.subTrace("Error lectura Ejercicio:" + error.getStackTrace() + "error.message:"+ error.message +"error.details:"+ error.details);
			}	
			return movimientos;
		}
	
		public function selectTrayectoria(idMovimiento: String):Array{
			
			var trayectorias: Array = new Array();
			try {
				var selectStmt: SQLStatement = new SQLStatement();
				selectStmt.sqlConnection = con;
				selectStmt.text = " select IdMovimiento, X, Y, Orden ";
				selectStmt.text += " from " + DBConstants.T_TRAYECTORIAS;
				selectStmt.text += " where IdMovimiento = @IdMovimiento ";
				selectStmt.text += " order by Orden";
				selectStmt.parameters["@IdMovimiento"] = idMovimiento; 
				selectStmt.execute();
				
				var result: SQLResult = selectStmt.getResult();
				
				if(result.data != null){
					for (var i:int = 0; i < result.data.length; i++){
						var tr: TrayectoriaBE = new TrayectoriaBE();	
						tr.movimiento = result.data[i]["IdMovimiento"];
						tr.orden = result.data[i]["Orden"];
						tr.punto = new Point(result.data[i]["X"], result.data[i]["Y"]);
						trayectorias[i] = tr;
					}				
				}
			}catch (error) {
				trace("error");
				Util.subTrace("Error lectura Ejercicio:" + error.getStackTrace() + "error.message:"+ error.message +"error.details:"+ error.details);
			}	
			return trayectorias;
		}
	}
	
}