﻿package org.pizarra.Converters{	

	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import flash.net.*;
	import flash.events.*;
	import org.pizarra.Util;
	import org.pizarra.Entity.*;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.util.Eventos;
	import org.pizarra.util.Constantes;
	import org.pizarra.Trayectoria;
	import flash.geom.Point;
	
	public class ExerciseConverter extends EventDispatcher{
		
		var ejXML: XML = <data></data>;
		
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function xmlAEjericio(url: String){
			Util.subTrace("Loading: " + url + " to an exercise");
			var xmlLoader:URLLoader = new URLLoader();
			xmlLoader.load(new URLRequest(url));
			xmlLoader.addEventListener(Event.COMPLETE, procesa_XML);
		}
		public function procesa_XML(e:Event):void {
		
			var xml: XML;
			try{
				xml = new XML(e.target.data);
				trace("-tipo: " + String(xml.type));
				if (String(xml.type) != Constantes.TYPE_EXERCISE){
					Util.subTrace("Error tipo documento");
					dispatchEvent(new Event(Eventos.WRONG_TYPE_IMPORT));
					return;
				}else{
					parseEjercicio(xml.ejercicio);
				}
			} catch (e:TypeError) {
				Util.subTrace("Error procesando XML");
				dispatchEvent(new Event(Eventos.ERROR_IMPORT));
				return;
         	}
		}
		public function ejericioAXML(e: Ejercicio): XML {
			
			var escena: XML = <escena></escena>;
			var auxEsc: Escena;
			var movimiento: XML = <movimiento></movimiento>;
			var auxMov: Movimiento;
			var punto: XML = <punto></punto>;
			
			e.imprime_ejercicio();
			
			Util.subTrace("Parsing: " + e.nombre + " to XML");
			ejXML.type = "Ejercicio";
			ejXML.ejercicio.id = e.id; 
			ejXML.ejercicio.nombre = e.nombre;
			ejXML.ejercicio.info = e.info;
			ejXML.ejercicio.fecha = e.fecha;
			ejXML.ejercicio.tipo = e.tipo;
			ejXML.ejercicio.deporte = e.deporte;
			ejXML.ejercicio.fondo = e.fondo;
			
			for (var i = 1; i < e.numEscenas ; i++ ) {	//	Para todas las escenas
				
				escena = <escena></escena>;
				auxEsc = e.escenas[i];
				escena.id_ejercicio = e.id;
				escena.id_escena = auxEsc.ID;
				escena.tipo = auxEsc.tipo;
				escena.duracion = auxEsc.duracion;
				escena.audio = auxEsc.audio;
				escena.texto = auxEsc.texto;
				
				for (var j = 0; j < auxEsc.nMovimientos ; j++ ) {	//	Para todos los movientos
					
					movimiento = <movimiento></movimiento>;
					auxMov = auxEsc.movimientos[j];
					movimiento.id_ejercicio = e.id;
					movimiento.id_escena = auxEsc.ID;
					movimiento.id_movimiento = auxMov.id;
					movimiento.secuencia = auxMov.secuencia;
					movimiento.tipo = auxMov.tipo;
					movimiento.elemento = auxMov.elemento;
					movimiento.inicio_x = auxMov.inicio.x;
					movimiento.inicio_y = auxMov.inicio.y;
					movimiento.fin_x = auxMov.fin.x;
					movimiento.fin_y = auxMov.fin.y;
					movimiento.etiqueta = auxMov.etiqueta;
					movimiento.rotacion = auxMov.rotacion;
					
					for each(var pto in auxMov.trayectorias ) {		//	For all points
						
						punto = <punto></punto>
						punto.x = pto.x;
						punto.y = pto.y;
						movimiento.puntos = punto;
					}
					escena.movimientos = movimiento;
				}
				ejXML.ejercicio.escenas = escena; 
			}
			return ejXML;
		}
		
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		public function parseEjercicio(e: XMLList): Ejercicio{
			
			var ej: Ejercicio;
			var es: Escena;
			var esc: Array = new Array();
			var mov: Movimiento;
			var movs: Array = new Array();
			var aux_e: XMLList;
			var aux_m: XMLList;
						
			ej = new Ejercicio("", e.nombre, e.info, e.fecha, e.tipo, e.deporte, e.fondo);
			for(var i=1; i< e.b.escena.length(); i++){
				aux_e = e.b.escena[i];
				trace(aux_e.movimientos.movimiento[0]);
				es = new Escena(aux_e.id_escena, aux_e.tipo, aux_e.duracion, aux_e.texto, aux_e.audio);
				es.escribe_escena();
				for(var j=0; j< aux_e.movimientos.movimiento.length(); j++){
					aux_m = aux_e.movimientos.movimiento[j];
					trace(aux_m);
				}
			}
			ej.imprime_ejercicio();
			dispatchEvent(new Event(Eventos.FINISHED_IMPORT));
			return ej;
		}
		
		public static function ParseXmlToEjercicioBE(e: XMLList): EjercicioBE{
			
			var ii: int = e.escena.length();
			var ej: EjercicioBE = new EjercicioBE();
			ej.nombre = e.nombre;
			ej.info = e.info;
			ej.fechaCreacion = null;
			ej.fechaModificacion = null;
			ej.tipo = e.tipo;
			ej.deporte = e.deporte;
			ej.fondo = e.fondo;
			ej.escenas = new Array();
			
			for( var i = 1; i<= ii ; i++){
				
				var esXml: XML = e.escena[i-1];
				var es: EscenaBE = new EscenaBE();
				es.id = esXml.id_escena;
				es.tipo = esXml.tipo;
				es.duracion = (int) (esXml.duracion);
				es.audio = esXml.audio;
				es.texto = esXml.texto;
				
				for(var j=0; j< esXml.movimiento.length(); j++){
					
					var movXml: XML = esXml.movimiento[j];
					var mov: MovimientoBE = new MovimientoBE();
					mov.id = movXml.id_movimiento;
					mov.elemento = movXml.elemento;
					mov.tipo = movXml.tipo;
					mov.etiqueta = movXml.etiqueta;
					mov.rotacion = movXml.rotacion;
					mov.preAccion = movXml.preAccion;
					mov.postAccion = movXml.postAccion;
					mov.inicio = new Point(movXml.inicio_x, movXml.inicio_y);
					mov.trayectoria = new Array();
					
					for(var k = 0; k < movXml.punto.length(); k++){
						var trayXml: XML = movXml.punto[k];
						var tray:  TrayectoriaBE = new TrayectoriaBE();
						tray.orden = k;
						tray.punto = new Point(trayXml.x, trayXml.y);
						trace(tray.punto);
						mov.trayectoria[k] = tray;
					}
					
					es.movimientos[j] = mov;
				}
				ej.escenas[i] = es;
			}
			return ej;
		}
		
		public static function EjericioBeToXml(e: EjercicioBE): XML {
			
			var ejXML: XML = <data></data>;
			var escena: XML = <escena></escena>;
			var auxEsc: EscenaBE;
			var movimiento: XML = <movimiento></movimiento>;
			var auxMov: MovimientoBE;
			var punto: XML = <punto></punto>;
			
			ejXML.type = "Ejercicio";
			ejXML.ejercicio.id = e.id; 
			ejXML.ejercicio.nombre = e.nombre;
			ejXML.ejercicio.info = e.info;
			ejXML.ejercicio.fechaCreacion = e.fechaCreacion;
			ejXML.ejercicio.fechaModificacion  = e.fechaModificacion;
			ejXML.ejercicio.tipo = e.tipo;
			ejXML.ejercicio.deporte = e.deporte;
			ejXML.ejercicio.fondo = e.fondo;
			
			for (var i = 1; i < e.escenas.length ; i++ ) {	//	Para todas las escenas
				
				escena = <escena></escena>;
				auxEsc = e.escenas[i];
				escena.id_ejercicio = ejXML.ejercicio.id;
				escena.id_escena = auxEsc.id;
				escena.tipo = auxEsc.tipo;
				escena.duracion = auxEsc.duracion;
				escena.audio = auxEsc.audio;
				escena.texto = auxEsc.texto;
				escena.movimientos = <movimientos></movimientos>
				for (var j = 0; j < auxEsc.movimientos.length ; j++ ) {	//	Para todos los movientos
					
					movimiento = <movimiento></movimiento>;
					auxMov = auxEsc.movimientos[j];
					movimiento.id_ejercicio = ejXML.ejercicio.id;
					movimiento.id_escena = auxEsc.id;
					movimiento.id_movimiento = auxMov.id;
					movimiento.secuencia = auxMov.orden;
					movimiento.tipo = auxMov.tipo;
					movimiento.elemento = auxMov.elemento;
					movimiento.preAccion = auxMov.preAccion;
					movimiento.postAccion = auxMov.postAccion;
					movimiento.inicio_x = auxMov.inicio.x;
					movimiento.inicio_y = auxMov.inicio.y;
					movimiento.etiqueta = auxMov.etiqueta;
					movimiento.rotacion = auxMov.rotacion;
					
					for each(var pto:TrayectoriaBE in auxMov.trayectoria ) {		//	For all points
						
						punto = <punto></punto>
						punto.x = pto.punto.x;
						punto.y = pto.punto.y;
						movimiento.puntos = punto;
					}
					escena.movimientos[j] = movimiento;
				}
				ejXML.ejercicio.escenas = escena; 
			}
			return ejXML;
		}
		
		
	}
	
}