package org.pizarra.Common
{
	import org.pizarra.Entity.*;
	
	public class Util {
		
		//	Returns the XML representation of the Exercise
		public static function EjercicioToXml(e: EjercicioBE):XML {
		
			var ejXML: XML = <data></data>;
			var escena: XML = <escena></escena>;
			var auxEsc: EscenaBE;
			var movimiento: XML = <movimiento></movimiento>;
			var auxMov: MovimientoBE;
			var punto: XML = <punto></punto>;
			
			trace("Parsing: " + e.nombre + " to XML");
			ejXML.type = "Ejercicio";
			ejXML.ejercicio.id = e.id; 
			ejXML.ejercicio.nombre = e.nombre;
			ejXML.ejercicio.info = e.info;
			ejXML.ejercicio.FechaCreacion = e.fechaCreacion;
			ejXML.ejercicio.FechaModificacion = e.fechaModificacion;
			ejXML.ejercicio.tipo = e.tipo;
			ejXML.ejercicio.deporte = e.deporte;
			ejXML.ejercicio.fondo = e.fondo;
			
			for (var i = 1; i < e.escenas.length ; i++ ) {	//	Para todas las escenas
				
				escena = <escena></escena>;
				auxEsc = e.escenas[i];
				escena.id_ejercicio = e.id;
				escena.id_escena = auxEsc.id;
				escena.tipo = auxEsc.tipo;
				escena.duracion = auxEsc.duracion;
				escena.audio = auxEsc.audio;
				escena.texto = auxEsc.texto;
				
				for (var j = 0; j < auxEsc.movimientos.length ; j++ ) {	//	Para todos los movientos
					
					movimiento = <movimiento></movimiento>;
					auxMov = auxEsc.movimientos[j];
					movimiento.id_ejercicio = e.id;
					movimiento.id_escena = auxEsc.id;
					movimiento.id_movimiento = auxMov.id;
					movimiento.orden = auxMov.orden;
					movimiento.tipo = auxMov.tipo;
					movimiento.elemento = auxMov.elemento;
					movimiento.etiqueta = auxMov.etiqueta;
					movimiento.rotacion = auxMov.rotacion;
					movimiento.accion = auxMov.accion;
					
					for(var k = 0; k < auxMov.trayectoria.length; k++ ) {		//	For all points
						
						/*punto = <punto></punto>
						punto.x = pto.y;
						punto.y = pto.y;
						movimiento.puntos = punto;*/
					}
					escena.movimientos[j] = movimiento;
				}
				ejXML.ejercicio.escenas[i] = escena; 
			}
			
			//trace(ejXML);
			return ejXML;
		}
	}
	
}