﻿package org.alivepdf.funciones{
	
	import org.alivepdf.pdf.PDF;
	import org.alivepdf.layout.Orientation;
	import org.alivepdf.layout.Size;
	import org.alivepdf.layout.Unit;
	import org.alivepdf.display.Display;
	import org.alivepdf.saving.Method;
	import org.alivepdf.fonts.FontFamily;
	import org.alivepdf.fonts.Style;
	import org.alivepdf.colors.RGBColor;
	import org.alivepdf.images.ImageFormat;
	import org.alivepdf.funciones.Funciones_PDF;
	import flash.geom.Rectangle;
	//import flash.filesystem.File;
	import flash.net.FileReference;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import flash.filesystem.*;
		
	public class Funciones_PDF{
		
		public function bytes_image(url:String):ByteArray{
			var img:File;
			var pictureBytes:ByteArray = new ByteArray();
			img = File.desktopDirectory.resolvePath(url);
			var stream:FileStream = new FileStream();
			stream.open(img,FileMode.READ);
			stream.readBytes(pictureBytes);
			return pictureBytes;
		}
		
		public function portada(myPDF:PDF,texto:String):void{
			myPDF.addText (texto, 20, 17.5);
			//myPDF.addImageStream(bytes_image("img/logo.png"),0,25); 
			myPDF.addPage();
		}
		
		public function indice(myPDF:PDF, el:Array):void{
			
			cabecera(myPDF,"INDICE DE CONTENIDOS");
			pie(myPDF,"",1);
			for(var i:int = 0; i < el.length; i++){
				myPDF.addText (el[i].nombre, 20, 50 + 10*(i));
				myPDF.addText ("pág " + (i+2).toString(), 180, 50 + 10*(i));
			}
			myPDF.addPage();
		}
		
		public function cabecera(myPDF:PDF, texto:String):void{
			
			myPDF.drawRoundRect ( new Rectangle ( 10, 10, 190, 15 ), 2 );
			myPDF.addText (texto, 20, 17.5);
		}
		
		public function pie(myPDF:PDF, texto:String, num:int):void{
			
			myPDF.drawRoundRect ( new Rectangle ( 10, 272, 190, 15 ), 2 );
			myPDF.addText (texto, 20, 280);
			myPDF.addText ('Página '+num.toString(), 170, 280);
		}
	}
}