﻿package org.pizarra.helpers{	
	import flash.display.Loader;
	import flash.display.Sprite;
	import org.pizarra.*;
	import org.pizarra.graficos.Elemento_Concreto;
	import org.pizarra.graficos.DrawingShapes;
	import org.pizarra.graficos.DashedLine;
	import org.pizarra.graficos.Draw;
	import org.pizarra.util.*;
	import org.pizarra.configuracion.*;
	import flash.events.*;
	import flash.geom.Point;
	import com.dncompute.graphics.GraphicsUtil;
	
	public class PathManager {
		
		private var _panel: Sprite;
		private var _contenedor: Sprite;
		private var _cierre: Loader;
		private var _path: Trayectoria;
		private var circles: Array;
		private var lines: Array;
		private var dibujoTrayectoria: Sprite;
		private var dibujoBezier: Sprite;
		private var _el: Elemento_Concreto;
		private var active: Boolean = false;
		private var currentCircle: int;
		
		public function PathManager(panel: Sprite, cierre: Loader){
			_panel = panel;
			_cierre = cierre;	
			circles = new Array();
			lines = new Array();
		}
		
		public function startPath(tipo: int, el: Elemento_Concreto, contenedor: Sprite) {
			_el = el;
			_contenedor = contenedor;
			active = true;
			restartData();
			_contenedor.addChild(dibujoTrayectoria);
			switch(tipo) {
				case Acciones.ZIGZAG:
					_path.tipo = Trayectorias.T_ZIGZAG;
					startZigzag();
					break;
				case Acciones.ZIGZAG_DIS:
					_path.tipo = Trayectorias.T_ZIGZAG_DIS;
					startZigzag();
					break;
				case Acciones.CIRCULAR:
					_path.tipo = Trayectorias.T_CIRCULAR;
					startCircular();
					break;
				case Acciones.CIRCULAR_DIS:
					_path.tipo = Trayectorias.T_CIRCULAR_DIS;
					startCircular();
					break;
			}
		}
		
		private function restartData() {

			_path = new Trayectoria(new Point(_el.x, _el.y));
			dibujoTrayectoria = new Sprite();
			circles = new Array();
			lines = new Array();
		}
		
		public function endPath(): Trayectoria {
			if (_panel.hasEventListener(MouseEvent.CLICK)) {
				if(_path.tipo == Trayectorias.T_ZIGZAG || _path.tipo == Trayectorias.T_ZIGZAG ){
					_panel.removeEventListener(MouseEvent.CLICK, clickZigZag);
				}
				if(_path.tipo == Trayectorias.T_CIRCULAR || _path.tipo == Trayectorias.T_CIRCULAR_DIS ){
					_panel.removeEventListener(MouseEvent.CLICK, clickBezier);
				}
			}
			active = false;
			return _path;
		}
		
		//	<EDICION>
		public function continuePath(contenedor: Sprite, t: Trayectoria) {
			
			
			//	Dibuja la trayectoria
			drawPath(contenedor, t);
			_path = t;
			for each(var c: Sprite in circles) {
				c.addEventListener(MouseEvent.MOUSE_DOWN, pulsa_circulo);
				c.addEventListener(MouseEvent.MOUSE_UP, suelta_circulo);
				c.buttonMode = true;
				c.useHandCursor = true;
			}
			_path.audita();
		}
		
		public function pulsa_circulo(e: Event) {
			_path.audita();
			e.target.startDrag();
			currentCircle = circles.indexOf(e.target);
			e.target.addEventListener(MouseEvent.MOUSE_MOVE, mueve_circulo);
			//if(tipo_tray[semaforo.escena] == 1)
				//principal.removeEventListener(MouseEvent.CLICK, click_zigzag);
				//principal.removeEventListener(MouseEvent.CLICK, click);
			//if(tipo_tray[semaforo.escena] == 2)
				//principal.removeEventListener(MouseEvent.CLICK, click_circular);
				//principal.removeEventListener(MouseEvent.CLICK, click);
		}
		
		public function suelta_circulo(e: Event){
			
			e.target.stopDrag();
			e.target.removeEventListener(MouseEvent.MOUSE_MOVE, mueve_circulo);
			//var i: int = circles.indexOf(e.target);
			/*tr[semaforo.escena][i] = new Point(e.target.x,e.target.y);
			if(tipo_tray[semaforo.escena] == 1){
				elimina_t();
				dibuja_trayectoria(true);
				principal.addEventListener(MouseEvent.CLICK, click_zigzag);
			}
			if(tipo_tray[semaforo.escena] == 2){
				dibuja_bezier();
				principal.addEventListener(MouseEvent.CLICK, click_circular);
			}*/
		}
		
		public function mueve_circulo(e: MouseEvent){
			
			//	Guarda el nuevo punto
			_path.puntos[currentCircle] = new Point(e.target.x, e.target.y);
			//	Actualiza las líneas
			if (_path.tipo == Trayectorias.T_ZIGZAG || _path.tipo == Trayectorias.T_ZIGZAG_DIS) {
				redibuja_lineas(currentCircle);
				dibujoTrayectoria.addChild(circles[currentCircle]);
			}
			if (_path.tipo == Trayectorias.T_CIRCULAR || _path.tipo == Trayectorias.T_CIRCULAR_DIS) {
				//dibuja_bezier();
			}
		}
		
		public function redibuja_lineas(i: int){
			//Mueve las líneas anterior y posterior si existe;
			//	Línea anterior
			if(i == 0){	//	Primer punto
				//dibujoTrayectoria.removeChild(lines[0]);
				dibuja_linea_en(new Point(_el.x + _panel.x,_el.y + _panel.y),_path.puntos[0], i);
			}else{
				//dibujoTrayectoria.removeChild(lines[i]);
				dibuja_linea_en(_path.puntos[i-1],_path.puntos[i], i);
			}
			if((lines.length - 1) > i){
				//dibujoTrayectoria.removeChild(lines[i+1]);
				dibuja_linea_en(_path.puntos[i],_path.puntos[i+1],i+1);
			}
		}
		
		//	</EDICION>
		
		public function drawPath(contenedor: Sprite, t: Trayectoria) {
			
			if(!t.isEmpty()){
				_contenedor = contenedor;
				active = true;
				restartData();
				//	adds the draw container
				if ((t.tipo == Trayectorias.T_ZIGZAG) || (t.tipo == Trayectorias.T_ZIGZAG_DIS)) {
					dibujoTrayectoria = new Sprite();
					_contenedor.addChild(dibujoTrayectoria);
					//for each(var p: Point in t.puntos) {
					for (var i: int = 0; i < t.puntos.length - 1; i++) {
						if (i == 0) {
							//	Draw the first line from the element
							dibuja_linea(new Point(	t.element.x + _panel.x,
													t.element.y + _panel.y),
										t.puntos[i]);
							dibuja_linea(t.puntos[i], t.puntos[i+1]);
						}
						else {
							dibuja_linea(t.puntos[i], t.puntos[i+1]);
						}
						drawPoint(t.puntos[i]);
					}
				}
				if ((t.tipo == Trayectorias.T_CIRCULAR) || (t.tipo == Trayectorias.T_CIRCULAR_DIS)) {
					dibujoBezier = new Sprite();
					_contenedor.addChild(dibujoBezier);
				}
			}
		}
		
		private function startZigzag() {	
			_panel.addEventListener(MouseEvent.CLICK, clickZigZag);
		}
		
		private function clickZigZag(e: MouseEvent) {
			if(e.target != _cierre){			
				add_nodo(new Point(e.localX, e.localY ));		
			}
		}
		
		private function startCircular() {
			dibujoBezier = new Sprite();
			_contenedor.addChild(dibujoBezier);
			_panel.addEventListener(MouseEvent.CLICK, clickBezier);
		}
		
		private function clickBezier(e: MouseEvent) {
			if(e.target != _cierre){			
				add_nodo_circular(new Point(e.stageX, e.stageY));		
			}
		}
			
		//	<ZIGZAGS>
		private function add_nodo(p: Point){
			
			Util.subTrace("  == New Dot path added " + p);
			drawLine(p);		//	Draws the linking line
			drawPoint(p);		//	Draws the point
			_path.addPunto(p);	//	Stores the point
			puntos_al_frente();
		}
		
		private function drawPoint(p: Point) {

			//	Punto
			var i: int = circles.length;
			circles[i] = new Sprite(); 						
			circles[i].graphics.beginFill( Tema.dotColor , 1 );
			circles[i].graphics.lineStyle( 1, 0x000000 );
			circles[i].graphics.drawCircle( 0 , 0 , 5 );
			circles[i].graphics.endFill();
			circles[i].x = p.x;	
			circles[i].y = p.y;
			dibujoTrayectoria.addChild( circles[i] );
			/*if(listeners){
				circles[i].addEventListener(MouseEvent.MOUSE_DOWN, pulsa_circulo);
				circles[i].addEventListener(MouseEvent.MOUSE_UP, suelta_circulo);
				circles[i].buttonMode = true;
				circles[i].useHandCursor =true;
			}*/
		}
		
		//	Draws the line to the point p (different types acording to the type of path)
		private function drawLine(p: Point) {
			
			var init, fin : Point;
			//	Stores beginning and ending
			if( _path.isEmpty() ){		
				//	Primer punto desde el centro del elemento
				init = new Point(_el.x + _panel.x, _el.y + _panel.y);
				fin = p;
			}else {		
				//	siguientes puntos desde el anterior
				init = _path.ultimoPunto;
				fin = p;
			}
			//	Draws the line
			if(_path.tipo == Trayectorias.T_ZIGZAG){
				dibuja_linea(init, fin);
			}
			if(_path.tipo == Trayectorias.T_ZIGZAG_DIS){
				dibuja_linea_dis(init, fin);
			}
		}
		
		//	Effectively draw the line between init and end with an arrow
		public function dibuja_linea(init: Point, fin: Point){
			
			var i: int = lines.length;
			lines[i] = new Sprite();
			lines[i].graphics.lineStyle(1,0x000000);
			lines[i].graphics.beginFill(Tema.lineColor);
			GraphicsUtil.drawArrow(
					lines[i].graphics,
					new Point(init.x ,init.y),
					new Point(fin.x ,fin.y));
			dibujoTrayectoria.addChild(lines[i]);
		}
		
		public function dibuja_linea_en(init: Point, fin: Point, i: int){
			
			if (dibujoTrayectoria.contains(lines[i])) {
				dibujoTrayectoria.removeChild(lines[i]);
			}
			lines[i] = new Sprite();
			lines[i].graphics.lineStyle(1,0x000000);
			lines[i].graphics.beginFill(Tema.lineColor);
			GraphicsUtil.drawArrow(
					lines[i].graphics,
					new Point(init.x ,init.y),
					new Point(fin.x ,fin.y));
			dibujoTrayectoria.addChild(lines[i]);
		}
		
		public function dibuja_linea_dis(init: Point, fin: Point){
			
			var i: int = lines.length;
			lines[i] = new Sprite();
			lines[i].graphics.lineStyle(3,Tema.lineColor);
			DrawingShapes.drawDash(	lines[i].graphics,
									init.x,
									init.y,
									fin.x, 
									fin.y);
			//	Draw the arrow
			GraphicsUtil.drawArrow(
					lines[i].graphics,
					new Point(fin.x - _panel.x ,fin.y),
					new Point(fin.x - _panel.x ,fin.y));
			dibujoTrayectoria.addChild(lines[i]);
		}
		
		//	</ZIGZAGS>
		//	<BEZIER>
		private function add_nodo_circular(p: Point){
			
			Util.subTrace("  == New Dot path added " + p);
			drawPoint(p);		//	Draws the point
			_path.addPunto(p);	//	Stores the point
			if( !_path.isEmpty() ){		//	Primer punto desde el centro del elemento
				dibuja_bezier();
			} 
			puntos_al_frente();
		}
		
		public function dibuja_bezier():void{
			
			_contenedor.removeChild(dibujoBezier);
			dibujoBezier = new Sprite();
			_contenedor.addChild(dibujoBezier);
			
			var pointArray = new Array();
			var dibujo = new Array();
			var elem = new Array();
			var numPoints = _path.nPuntos;
			var oData = new Object();
			
			for(var i:int = 1; i <= numPoints; i++){
				pointArray.push(_path.puntos[i]);
				elem[i] = new Object();
				elem[i]["x"] = _path.puntos[i].x;
				elem[i]["y"] = _path.puntos[i].y;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(_el.x + _panel.x, _el.y + _panel.y);
			var point_1: Point = _path.puntos[0];
			elem[i] = new Object();
			elem[i]["x"] = point_1.x;
			elem[i]["y"] = point_1.y;
			dibujo.push(elem[i]);
			
			for(i = 0; i<pointArray.length; i++){
				oData["x"+i] = pointArray[i].x;
				oData["y"+i] = pointArray[i].y;
				oData["dx"+i] = ((i+1) == numPoints) ? point_1.x : pointArray[(i+1)].x;
				oData["dy"+i] = ((i+1) == numPoints) ? point_1.y : pointArray[(i+1)].y;
				oData["cx"+i] = (oData["x"+i]+oData["dx"+i])/2;
				oData["cy"+i] = (oData["y"+i]+oData["dy"+i])/2;
			}
			
			if(_path.tipo == Trayectorias.T_CIRCULAR){
			//	CIRCULAR NOTMAL
				dibujoBezier.graphics.lineStyle(1, Tema.bezColor, 50);
				dibujoBezier.graphics.moveTo(point_0.x, point_0.y);
				for (i=0; i<numPoints; i++) {
					dibujoBezier.graphics.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);
				}
				dibujoBezier.graphics.lineTo(point_1.x, point_1.y);
			}
			if (_path.tipo == Trayectorias.T_CIRCULAR_DIS) {
				var dl = new DashedLine(dibujoBezier,1,5);
				dl.lineStyle(3,0x000000,1);
				dl.moveTo(point_0.x, point_0.y);
				for (i=0; i<numPoints; i++) {
					dl.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);		
				}
				dl.lineTo(point_1.x, point_1.y);
			}
		}
		//	</BEZIER>
		
		//	inserts in the container again to move to the top of the display stack(over the lines)
		private function puntos_al_frente() {	
			for each(var c: Sprite in circles) {
				dibujoTrayectoria.addChild(c);
			}
		}
		
		
		public function isActive() {
			return active;
		}
		
	}
}