﻿package org.pizarra.graficos.trayectoria {
	import flash.display.Sprite;
	import flash.geom.Point;
	import org.pizarra.configuracion.Settings;
	import org.pizarra.graficos.*;
	import com.dncompute.graphics.GraphicsUtil;
	
	public class LineaDiscontinua extends Sprite {
		
		private var init: Point;
		private var end: Point;
		private var arrow: Sprite = new Sprite();
		
		public function LineaDiscontinua(init: Point, fin: Point):void{ 
			
			this.init = init;
			this.end = fin;
			this.addChild(arrow);
			
			ReDraw();
			
			/*graphics.lineStyle(Settings.Line_ThickNess,Settings.Line_color);
			graphics.beginFill(Settings.Line_color);
			DrawingShapes.drawDash(	graphics,
									init.x,
									init.y,
									fin.x, 
									fin.y);
			//	Draw the arrow
			GraphicsUtil.drawArrow(
					graphics,
					new Point(fin.x ,fin.y),
					new Point(fin.x ,fin.y));*/

		}
		
		public function ReDraw(): void {
			
			this.removeChild(arrow);
			arrow = new Sprite();
			this.addChild(arrow);
			arrow.graphics.lineStyle(Settings.Line_ThickNess,Settings.Border_color);
			arrow.graphics.beginFill(Settings.Line_color);
			
			DrawingShapes.drawDash(	arrow.graphics,
									init.x,
									init.y,
									end.x, 
									end.y);
			//	Draw the arrow
			GraphicsUtil.drawArrow(
					arrow.graphics,
					new Point(end.x ,end.y),
					new Point(end.x ,end.y));
		}
		
		public function set Init(value: Point): void {
			this.init = value;
			ReDraw();
		}
		
		public function set End(value: Point): void {
			this.end = value;
			ReDraw();
		}
	}
}