﻿package org.pizarra.graficos.trayectoria {
	import flash.display.Sprite;
	import flash.geom.Point;
	import org.pizarra.configuracion.Settings;
	import com.dncompute.graphics.GraphicsUtil;
	
	public class Linea extends Sprite {
		
		public var init: Point;
		public var end: Point;
		private var arrow: Sprite = new Sprite();
		
		public function Linea(init: Point, fin: Point):void{ 
		
			this.init = init;
			this.end = fin;
			this.addChild(arrow);
			ReDraw();
			/*graphics.lineStyle(1,0x000000);
			graphics.beginFill(Settings.Line_color);
			
			GraphicsUtil.drawArrow(
					graphics,
					new Point(init.x ,init.y),
					new Point(fin.x ,fin.y));*/
		}
		
		public function ReDraw(): void {
			
			this.removeChild(arrow);
			arrow = new Sprite();
			this.addChild(arrow);
			arrow.graphics.lineStyle(Settings.Line_ThickNess,Settings.Border_color);
			arrow.graphics.beginFill(Settings.Line_color);
			
			GraphicsUtil.drawArrow(
					arrow.graphics,
					new Point(init.x ,init.y),
					new Point(end.x ,end.y));
		}
		
		public function set Init(value: Point): void {
			this.init = value;
			ReDraw();
		}
		
		public function set End(value: Point): void {
			this.end = value;
			ReDraw();
		}
	}
}