﻿package org.pizarra.graficos{	
	
	import org.pizarra.graficos.Elemento_Concreto;
	import flash.display.*;
	import flash.geom.Point;
	import org.pizarra.util.Semaforo;

	public class Trayectorias{
		
		private var e: Elemento_Concreto;
		private var principal: Sprite;
		private var mc_bez: MovieClip;
		private var dibujo = new Array();
		private var tr: Array;
		private var semaforo: Semaforo;
		private var mc: MovieClip;
		
		public function Trayectorias(e: Elemento_Concreto){
			this.e = e;
			principal = e.p_principal;
			mc_bez = e.bezier;
			tr = e.get_tr;
			//semaforo = e.get_semaforo;
			mc = e.get_mc();
		}
		
		public function dibuja_bezier():void{
			
			principal.removeChild(mc_bez);
			mc_bez = new MovieClip();
			principal.addChild(mc_bez);
			
			var pointArray = new Array();
			dibujo = new Array();
			var elem = new Array();
			var numPoints = tr[semaforo.escena].length-1;
			var oData = new Object();
			
			for(var i:int = 1; i<=numPoints; i++){
				pointArray.push(tr[semaforo.escena][i]);
				elem[i] = new Object();
				elem[i]["x"] = tr[semaforo.escena][i].x;
				elem[i]["y"] = tr[semaforo.escena][i].y;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(mc.x,mc.y);
			var point_1: Point = tr[semaforo.escena][0];
			elem[i] = new Object();
			elem[i]["x"] = point_1.x;
			elem[i]["y"] = point_1.y;
			dibujo.push(elem[i]);
			
			for(i = 0; i<pointArray.length; i++){
				oData["x"+i] = pointArray[i].x;
				oData["y"+i] = pointArray[i].y;
				oData["dx"+i] = ((i+1) == numPoints) ? point_1.x : pointArray[(i+1)].x;
				oData["dy"+i] = ((i+1) == numPoints) ? point_1.y : pointArray[(i+1)].y;
				oData["cx"+i] = (oData["x"+i]+oData["dx"+i])/2;
				oData["cy"+i] = (oData["y"+i]+oData["dy"+i])/2;
			}
			mc_bez.graphics.lineStyle(1, semaforo.prefs.bez_color, 50);
			mc_bez.graphics.moveTo(point_0.x, point_0.y);
			for (i=0; i<numPoints; i++) {
				mc_bez.graphics.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);
			}
			mc_bez.graphics.lineTo(point_1.x, point_1.y);
		}
	}
}