﻿package org.pizarra.graficos{	
	
	import fl.containers.ScrollPane; 
	import fl.controls.ScrollPolicy; 
	import fl.controls.DataGrid; 
	import fl.data.DataProvider; 
	import flash.display.*;
	import flash.geom.Point;
	import flash.events.*;
	import flash.net.*;
	
	//Transiciones
	import fl.transitions.*;
	import fl.transitions.easing.*; 

	
	public class Selector_Terreno{
		
		/*
		 *		CONFIGURACIÓN DEL ELEMENTO:
		 *		Todos los tamaños en pixels
		 */
		private var posicion: Point = new Point(40,490);
		private var altura: int = 95;
		//private var anchura: int = 570;
		private var anchura: int = 925;
		private var color: int = 0x424A4A;					//	Color del fondo
		private var alpha: Number = 0.5;					//	Entre 0.0 y 1.0
		
		private var ALTURA_THUMB: int = 95;
		private var ANCHURA_THUMB: int = 130;
		
		/*
		 *		ATRIBUTOS
		 */
		private var _scroll:ScrollPane = new ScrollPane(); 	//	Panel de desplazamiento
		private var _linea:Sprite = new Sprite();			//	Panel propiamente dicho
		private var contenedor: DisplayObjectContainer;		//	Panel de la escena donde dibujar la linea de tiempo
		
		private var n_imagenes: uint = 0;
		private var actual: uint = 0;
		
		var loa = new Array();  
		private var thumbs: Array = new Array();
		var msgBox:Sprite = new Sprite();
		
		/*
		 *		CONSTRUCTOR
		 */
		public function Selector_Terreno(contenedor: DisplayObjectContainer): void{
			
			this.contenedor = contenedor;
			dibuja_fondo(anchura);    
			_scroll.source = _linea; 
			_scroll.setSize(anchura, altura); 
			_scroll.move(posicion.x, posicion.y);
			_scroll.horizontalScrollPolicy = "auto";
			_scroll.verticalScrollPolicy = "off";
			contenedor.addChild(_scroll); 
			_linea.addChild(msgBox);
		}
		
		/*
		 *		MÉTODOS
		 */
		private function dibuja_fondo(anchura: uint):void { 
		
			_linea.graphics.beginFill(color, alpha); 
			_linea.graphics.drawRect(0, 0, anchura, altura); 
			_linea.graphics.endFill();  
		}
		
		public function add(url: String): MovieClip{
			if((n_imagenes + 1) * ANCHURA_THUMB > anchura){
				dibuja_fondo((n_imagenes + 1) * ANCHURA_THUMB);
				_scroll.update();
			}
			loa[n_imagenes] = new Loader();
			loa[n_imagenes].x = n_imagenes * ANCHURA_THUMB;
			loa[n_imagenes].load(new URLRequest(url));
			thumbs[n_imagenes] = new MovieClip();
			thumbs[n_imagenes].addChild(loa[n_imagenes]);
			_linea.addChild(thumbs[n_imagenes]);
			//TransitionManager.start(thumbs[n_imagenes],{type:Fly, startPoint: 2, direction:Transition.IN, duration:2, easing:Strong.easeOut});
			n_imagenes ++;
			return thumbs[n_imagenes - 1];
		}
		
		public function selecciona(s: Sprite): uint{
			var elem: uint = thumbs.indexOf(s);
			return elem + 1;
			msgBox.x = thumbs[elem].x;
			_linea.addChild(msgBox);
			_scroll.update();
		}		
				
		/*
		 *		GETTERS Y SETTERS
		 */
		public function get scroll():Sprite{
			return _scroll;
		}
		public function get sprite():Sprite{
			return _linea;
		}
		public function get loaders():Array{
			return loa;
		}
	}
}



