﻿/*	
 *		Proyecto: 	Pizarra
 *		Autor:		Alberto Bolsa
 *		Fichero:	Selector_Elemento.as
 *		Creación:	Enero de 2010
 *		Descripción:Clase que representa tanto la lógica como la interfaz del selector
 *					de elementos, de cada uno de ellos, no del panel con los n selectores.
 *		Uso:		El fichero viene configurado a través de las constantes de la clase
 *					Se puede reconfugurar a través de la función ****
 *		Versión:	v5
 *		Modificaciones:
 *				v5- Retrabajado el interfaz para adaptarlo al scroll panel
 *					Elementos portados de MovieClips a Sprites.
 */
package org.pizarra.graficos{	
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.filesystem.File;
	import flash.display.Sprite;
	import flash.geom.Point;
	import fl.containers.ScrollPane;
	import org.pizarra.util.Semaforo;
	import org.pizarra.graficos.Elemento_Paleta;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.Entity.*;
	import org.pizarra.Jugador;
	import org.pizarra.Model.EditorModel;
	import org.pizarra.util.Eventos;
	import org.pizarra.events.*;
	
	public class Selector_Elementos extends Sprite{
		
		/*
		 *		CONFIGURACIÓN DEL ELEMENTO:
		 *		Todos los tamaños en pixels
		 */
		//private var posicion: Point = new Point(10,100);
		//private var posicion: Point = new Point(10,100);
		private var altura: int = 380;
		private var anchura: int = 165;
		private var color: int = 0x424A4A;				//	Color del fondo
		//private var alpha: Number = 1;					//	Entre 0.0 y 1.0
		private var thumb_w: uint = 50;
		private var thumb_h: uint = 50;
		private var padding: uint = 10;
		
		//	Visualización
		private var _scroll:ScrollPane = new ScrollPane(); 	//	Panel de desplazamiento
		private var _caja:Sprite = new Sprite();			//	Selector propiamente dicho
		
		//	Atributos
		private var f_x: Number;
		private var f_y: Number;
		
		var _paleta: Array = new Array();
		var instancias: Array;
		var principal: Sprite;
		var selector: MovieClip = new MovieClip();
		var semaforo: Semaforo;
		
		private var m: EditorModel;
		
		/*
		 *		CONSTRUCTOR
		 */		
		public function Selector_Elementos( modelo: EditorModel ){					
			this.m = modelo;
			this.instancias = modelo.instances;
			this.principal = modelo.pnEdicion;
			
			//	Se calculan los factores de conversión entre los elementos y el fondo
			var ancho_fondo_m: Number = m.p.fondoSeleccionado.anchura_m;
			var alto_fondo_m : Number = m.p.fondoSeleccionado.altura_m;
			var ancho_fondo_px: Number = m.p.fondoSeleccionado.anchura;
			var alto_fondo_px : Number = m.p.fondoSeleccionado.altura;
			f_x = ancho_fondo_px / ancho_fondo_m;
			f_y = alto_fondo_px / alto_fondo_m;
		}
		
		/*
		 *		MÉTODOS
		 */
		private function dibuja_fondo():void { 
		
			_caja.graphics.beginFill(color, alpha); 
			_caja.graphics.drawRoundRect(0, 0, anchura, altura,20,20); 
			_caja.graphics.endFill();  
		}
		
		public function agnade_elemento(elem: ElementoBE) {
			var el: Elemento_Paleta = new Elemento_Paleta(elem,f_x,f_y,instancias,principal,semaforo,m.p.stage)
			el.addEventListener(Eventos.ELEMENT_ADDED, add);
			el.addEventListener(ElementAddedEvent.ADDED_ELEMENT, add);
			el.addEventListener(ElementMoveEvent.MOVED_ELEMENT, move);
			_paleta.push(el);	
		}
		public function agnade_jugador(jug: Jugador){
			var elemento = new ElementoBE(jug.id, jug.nombre, "dinamico", jug.url, 50, 50);
			var el = new Elemento_Paleta(elemento, 1, 1, instancias, principal, semaforo, m.p.stage);
			el.addEventListener(ElementAddedEvent.ADDED_ELEMENT, add);
			el.addEventListener(ElementMoveEvent.MOVED_ELEMENT, move);
			_paleta.push(el);			
		}
		private function add(e: ElementAddedEvent) {
			this.dispatchEvent(new ElementAddedEvent(e.element));
		}
		private function move(e: ElementMoveEvent) {
			this.dispatchEvent(new ElementMoveEvent(e.element));
		}
		public function dibuja(){

			var y: int = -40;
			dibuja_fondo();    
			_scroll.source = _caja; 
			_scroll.setSize(anchura, altura);  
			this.addChild(_scroll);
			
			
			for(var i: uint=0; i<paleta.length; i++){
				if (i%2==0){	//	2 elementos por fila
					y += thumb_h;
					_paleta[i].dibuja(_caja,padding,y);
				}else{
					_paleta[i].dibuja(_caja,padding + thumb_w,y);
				}
			}
		}
		
		public function disable() {
			for each(var e: Elemento_Paleta in _paleta) {
				e.bloquea();
			}
		}
		
		public function enable() {
			for each(var e: Elemento_Paleta in _paleta) {
				e.activa();
			}
		}
		
		public function audita(){
			var i: uint;
			for(i=0; i<instancias.length; i++){
				instancias[i].escribe(i);
			}
		}
		
		/*
		 *		GETTERS Y SETTERS
		 */
		public function set dataSource(data: Array) {
			
			for each (var elem in data) {
				agnade_elemento(elem);
			}
			dibuja();
		}
		public function set playersDataSource(data: Array) {
			
			for each (var elem in data) {
				agnade_jugador(elem);
			}
			dibuja();
		}
		
		//	Obtiene el scrollPane para eliminarlo desde el registrador
		public function get scroll():Sprite{
			return _scroll;
		}
		
		public function get_instancias(): Array{
			return instancias;
		}
		
		public function get_selector(){
			return selector;
		}
		
		public function get paleta(): Array{
			return _paleta;
		}
	}
}