﻿package org.pizarra.graficos{	
	import flash.geom.Point;
	import flash.display.Sprite;
	import org.pizarra.Entity.MovimientoBE;
	import org.pizarra.util.Acciones;
	import org.pizarra.Trayectoria;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.trayectoria.Linea;
	import org.pizarra.graficos.trayectoria.LineaDiscontinua;
	import org.pizarra.graficos.trayectoria.Punto;
	import org.pizarra.graficos.trayectoria.Bezier;
	import org.pizarra.graficos.trayectoria.BezierDiscontinuo;
	import org.pizarra.graficos.trayectoria.BezierEntity;
	import org.pizarra.graficos.trayectoria.BezierDiscontinuoEntity;
	
	public class PathSprite extends Sprite{
		
		//	Atributes
		private var el: Sprite;
		private var mov: MovimientoBE;
		
		private var lineSprites: Array = new Array();
		private var pointSprites: Array = new Array();
		
		private var origin: Point;
		
		//	Constructor
		public function PathSprite(elemento: Sprite, mov: MovimientoBE, init: Point = null): void{
			this.el = elemento;
			this.mov = mov;
			DrawPath();
		}	
		
		//	Public
		public function DrawPath(): void{
			if(mov.tipo != "001" && mov.tipo != "002" 
			   && mov.tipo != "003" && mov.tipo != "004" )
			   return;
			   
			if(mov.tipo == "001" || mov.tipo == "002"){
				
				var _points = this.mov.trayectoria;
				
				for (var i = 0; i < _points.length; i++ ) {
					var init, fin: Point;
					
					if (i == 0) {
						//init = new Point(el.x + el.width / 2, el.y + el.height / 4);
						init = new Point(mov.inicio.x, mov.inicio.y);
					}else {
						init = _points[i - 1].punto;
					}
					if(el == null){
						init = _points[0].punto;
					}
					fin = _points[i].punto;
					
					if (mov.tipo == "001") {
						lineSprites.push(new Linea(init, fin));
					}
					if (mov.tipo == "002") {	
						lineSprites.push(new LineaDiscontinua(init, fin));
					}
					this.addChild(lineSprites[lineSprites.length - 1]);
					
					pointSprites.push(new Punto(_points[i].punto.x, _points[i].punto.y));
					this.addChild(pointSprites[pointSprites.length-1]);
				}
			}else{
				var _points = this.mov.trayectoria;
				
				for (var i = 0; i < _points.length; i++ ) {
					pointSprites.push(new Punto(_points[i].punto.x, _points[i].punto.y));
					this.addChild(pointSprites[pointSprites.length-1]);
				}
				
				var init: Point = (el == null)
									? new Point(_points[0].punto.x, _points[0].punto.y)
									//: new Point(el.x + el.width/2, el.y + el.height / 2);
									: new Point(mov.inicio.x, mov.inicio.y);
				
				if (mov.tipo == "003") {
					lineSprites.push(new BezierEntity(_points, init));
				}else {
					lineSprites.push(new BezierDiscontinuoEntity(_points,init));
				}
				this.addChild(lineSprites[lineSprites.length - 1]);
			}
		}
		
		//	Private
		
		//	Getters
		public function set PointVisibility(val: Boolean): void{
			
			for(var i: uint = 0; i < pointSprites.length; i++){
				pointSprites[i].visible = val;
			}
		}
		
		//	Setters

	}
}