﻿package org.pizarra.graficos{	
	
	import flash.events.*;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.net.URLRequest;
	import flash.display.Loader;
	import org.pizarra.util.Semaforo;
	import flash.geom.Point;
	import flash.display.Stage;
	import org.pizarra.Entity.*;
	
	//	Events
	import org.pizarra.events.*;
	
	public class Elemento_Paleta extends Sprite{
		
		/*
		 *		CONFIGURACIÓN DEL ELEMENTO:
		 *		Todos los tamaños en pixels
		 */
		 private var POS_PRINCIPAL: Point = new Point(160,50); 	//Posicion del panel principal
		
		private var id: String;
		private var nombre: String;
		private var url: String;
		private var anchura: int;
		private var altura: int;
		private var mc: MovieClip;
		private var loader:Loader;
		private var instances;
		private var panel: Sprite;
		private var principal: Sprite;
		private var semaforo: Semaforo;
		private var id_elemento: int;
		private var _el: ElementoBE;
		private var f_x, f_y: Number;
		
		private var _stage: Stage;
		/*
		 *		CONSTRUCTOR
		 *		Com: 	La mayoría de los arguento del constructor son necesarios para los elemenetos creados
		 *				En este objeto, los elementos de paleta y los concretos
		 */
		public function Elemento_Paleta(	/*id: int,nombre: String,url: String,anchura: int,altura: int,*/
									el: ElementoBE,
									f_x: Number,
									f_y: Number,
									instances,
									principal: Sprite,
									semaforo: Semaforo,
									stage: Stage){
			this.id= el.id;
			this.nombre = el.nombre;
			this.url = el.imagen;
			this.anchura = el.anchura *f_x;
			this.altura = el.altura *f_y;
			this.instances= instances;
			this.principal = principal;
			this.semaforo = semaforo;
			this._stage = stage;
			this.f_x = f_x;
			this.f_y = f_y;
			_el = el;
			POS_PRINCIPAL = new Point(principal.x,principal.y);
		}
		
		//	Dibuja la miniatura del elemento en la posición adecuada
		public function dibuja(lugar: Sprite, x: int, y: int){
			
			this.panel = lugar;
			mc = new MovieClip();			//	Crea y añade el movieclip donde se almacenará el elemento
			mc.x = x;	mc.y = y;
			mc.buttonMode = true;
			lugar.addChild(mc);					
			add_listeners();				//	Añade los listeners al objeto
			loader = new Loader();			//	Comienza la carga de la imagen en sí
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			loader.load(new URLRequest(url));
		}
				
		/*
		 *		Funciones para el bloqueo y activación de los elementos
		 */
		public function bloquea():void {	
			this.buttonMode = false;
			rem_listeners();	
		}
		
		public function activa():void {	
			this.buttonMode = true;
			add_listeners();	
		}
		
		private function rem_listeners():void{
			mc.removeEventListener( MouseEvent.MOUSE_DOWN, pulsado);
			mc.removeEventListener( MouseEvent.MOUSE_OVER, hover_image);
			mc.removeEventListener( MouseEvent.MOUSE_OUT, exit_image);
		}
		
		private function add_listeners():void{
			mc.addEventListener( MouseEvent.MOUSE_DOWN, pulsado);
			mc.addEventListener( MouseEvent.MOUSE_OVER, hover_image);
			mc.addEventListener( MouseEvent.MOUSE_OUT, exit_image);
		}
		
		
		/*
		 *		CALLBACKS
		 */
		//	Se ha cargado la imagen y ahora se puede redimensionar
		function imgLoaded(event:Event):void{
			var bmp:Bitmap = new Bitmap();
			bmp = loader.content as Bitmap;
			bmp.width = 50;
			bmp.height = 50;
			mc.addChild(bmp);
		}
		
		//	Creo el elemento concreto y le cedo el testigo gráfico
		function pulsado(event:MouseEvent):void{
		
			var e : Elemento_Concreto; 
			//e = new Elemento_Concreto(_el, f_x, f_y, instances, principal, semaforo, _stage);
			e = new Elemento_Concreto(_el, f_x, f_y, _stage);
			principal.addChild(e);
			trace(_el.anchura);
			e.x = event.stageX - POS_PRINCIPAL.x - (_el.anchura * f_x / 2);
			e.y = event.stageY - POS_PRINCIPAL.y - (_el.altura * f_y / 2);
			e.startDrag();
			//e.start_drag();
			
			//e.dibuja(principal, event.stageX - POS_PRINCIPAL.x, event.stageY - POS_PRINCIPAL.y);
			//e.addEventListener("Elemento_Added", anadido);
			e.addEventListener(ElementAddedEvent.ADDED_ELEMENT, anadido);
			e.addEventListener(ElementMoveEvent.MOVED_ELEMENT, movido);
			instances.push(e);
		}
		
		/*
		 * 	HANDLERS
		 */
		private function anadido(e: ElementAddedEvent ) { this.dispatchEvent(new ElementAddedEvent(e.element));}
		private function movido(e: ElementMoveEvent ) { this.dispatchEvent(new ElementMoveEvent(e.element)); }
		
		//	Efecto rollover sobre las imagenes
		function hover_image(event: Event): void{
			mc.alpha=0.5;
		}
		function exit_image(event: Event): void{
			mc.alpha=1;
		}
		
		/*
		 *		DEBUG
		 */
		public function escribe(orden: int = 0){
			trace(orden + " " + nombre + " x: "+ mc.x + " y: "+mc.y);
		}
	}
}