﻿package org.pizarra.escenas.editor{	

	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.Event;
	import org.pizarra.Pizarra;
	import org.pizarra.View.PreEditorView;
	import org.pizarra.graficos.Alert;
	import org.pizarra.util.*;

	public class PreEditorController extends EventDispatcher{
		
		private var p: Pizarra;
		private var editor: PreEditorView;

		public function PreEditorController(piz: Pizarra, editor: PreEditorView): void{
			
			this.p = piz;
			this.editor = editor;
			p.terr_select = 0;
			p.dep_select = 0;
			Alert.init(p.stage);
			editor.BtnBack.addEventListener(MouseEvent.CLICK, volver);
			editor.BtnCreate.addEventListener(MouseEvent.CLICK, siguiente);
			editor.deportes.addEventListener(Event.CHANGE, cambio_deporte);
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init(){
			
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volver(event: Event){
			dispatchEvent(new Event("volver"));
		}
		
		private function siguiente(event: Event) {
			if (checkValid()) {
				if (editor.tipos.selectedItem.Value == Constantes.DISPOSICION) {
					//p.nuevoDibujo.titulo =  editor.nombre;
					//p.nuevoDibujo.info = editor.informacion;
					p.dep_select = editor.deportes.selectedIndex;
					p.deporteSeleccionado = editor.deportes.selectedItem.Value;
					dispatchEvent(new Event(Eventos.CREAR_DIBUJO));
				}else {
					p.nombre = editor.nombre;
					p.informacion = editor.informacion;
					p.tipo_ejercicio = editor.tipos.selectedItem.Value;
					p.dep_select = editor.deportes.selectedIndex;
					p.deporteSeleccionado = editor.deportes.selectedItem.Value;
					dispatchEvent(new Event(Eventos.CREAR_EJERCICIO));
				}
				
			}else{
				Alert.show("Datos erróneos, compruebe antes de continuar", {background:"blur"});
			}
		}
		
		private function checkValid(): Boolean {
			/*trace("Deporte " + p.dep_select);
			trace("longitud " + p.deportes.length);
			trace("terreno " + p.terr_select);*/
			return ( (p.deportes[p.dep_select].fondos[p.terr_select] != null) 
					 && (editor.nombre != "")
					 && (editor.informacion != ""));													
		}
		
		private function cambio_deporte(e:Event){
			p.dep_select = editor.deportes.selectedIndex;
			p.deporteSeleccionado = editor.deportes.selectedItem.Value;
			editor.cargaFondos();
			editor.cargaThumbDeporte();
			p.terr_select = 0;
			editor.carga_seleccion(p.terr_select);
		}
		
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
	}
}