﻿package org.pizarra.View{	

	import fl.events.SliderEvent;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import fl.controls.Slider;
	import org.pizarra.Animation.AnimationHelper;
	import org.pizarra.Animation.ExerciseAnimation;
	import org.pizarra.Entity.*;
	import org.pizarra.View.*;
	import org.pizarra.graficos.Image;
	import org.pizarra.graficos.ImageButton;
	import org.pizarra.graficos.TextImageButton;
	import org.pizarra.helpers.SoundPlayer;
	import org.pizarra.Pizarra;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.util.Constantes;
	import org.pizarra.Util;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filesystem.File;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import fl.transitions.*;
	import fl.transitions.easing.*;
	import org.pizarra.util.*;
	import com.greensock.*;
	import org.pizarra.configuracion.Tema;
	
	public class VisorView extends View{
		
		private var p: Pizarra;
		private var pnBotonera: MovieClip;
		private var pnVideo: Sprite;
		private var fondo: Loader;
		
		private var _atras: Loader;
		private var _delante: Loader;
		private var _pausa: Loader;
		private var _play: Loader;
		private var _reverse: Loader;
		private var _slider: Slider;
		
		private var ej: EjercicioBE;
		private var Elements: Array = new Array();
		
		private var btnInfo, btnBack: TextImageButton;
		private var els: Array = new Array();
		
		private var infoPanel: MovieClip = new MovieClip();
		
		var ex :ExerciseAnimation;
		
		public function VisorView(piz: Pizarra): void {
			super((piz.urlEjercicio != null && piz.urlEjercicio != "")
				  ? "Importado" : piz.hEjercicios[piz.ejercicioSeleccionado].nombre);
			this.p = piz;
			inicializaComponentes();
			_play.addEventListener(MouseEvent.CLICK, play_Click);
			_pausa.addEventListener(MouseEvent.CLICK, pause_Click);
			slider.addEventListener(SliderEvent.CHANGE, changeTime);
			
			if(piz.urlEjercicio != null && piz.urlEjercicio != "") {
				
			} else {
				ej = piz.hEjercicios[piz.ejercicioSeleccionado];
				//super(piz.hEjercicios[piz.ejercicioSeleccionado].nombre);
				ex = new ExerciseAnimation(ej, p.hFondos[ej.fondo], p.hElementos);
				ex.addEventListener(Event.COMPLETE, finishedLoading);
				ex.addEventListener(Event.CHANGE, frameChange);
				ex.x = 100; ex.y = 100;
				addChild(ex);
			}
			
			//	Create info Panel
			createInfoPanel();
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function inicializaComponentes(){
			creaPanel();
			dibujaSlider();
			posicionaComandos();
			posicionaBotones();
		}
		
		private function creaPanel(){
			pnBotonera = new MovieClip(); 
			this.addChild(pnBotonera);
			pnBotonera.x = 200;
			pnBotonera.y = 500;
		}
		
		private function dibujaSlider(){
			_slider = new Slider();
			pnBotonera.addChild(_slider);
			Util.posiciona(_slider,0,50,500,10);
			_slider.snapInterval = 100;
			_slider.minimum = 0.0;
			_slider.height = 10;
			_slider.liveDragging = true;
		}
		
		private function posicionaComandos(){
			
			_atras = new Loader(); 
			var urlReq:URLRequest = new URLRequest(Constantes.IMG_VISOR_ATRAS);
			_atras.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_atras.load(urlReq);
			pnBotonera.addChild(_atras);
			
			_delante = new Loader(); 
			urlReq = new URLRequest(Constantes.IMG_VISOR_DELANTE);
			_delante.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_delante.load(urlReq);
			pnBotonera.addChild(_delante);
			
			_pausa = new Loader(); 
			urlReq = new URLRequest(Constantes.IMG_VISOR_PAUSA);
			_pausa.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_pausa.load(urlReq);
			pnBotonera.addChild(_pausa);
			
			_play = new Loader(); 
			urlReq = new URLRequest(Constantes.IMG_VISOR_PLAY);
			_play.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_play.load(urlReq);
			pnBotonera.addChild(_play);
			
			_reverse = new Loader(); 
			urlReq = new URLRequest(Constantes.IMG_VISOR_REVERSE);
			_reverse.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_reverse.load(urlReq);
			pnBotonera.addChild(_reverse);
		}
		
		private function posicionaBotones(){
			
			btnInfo = new TextImageButton(Ficheros.IMG_INFO, "Info" );
			btnInfo.x = 860; btnInfo.y = 4;
			//btnInfo.addEventListener(MouseEvent.CLICK, info);
			addChild(btnInfo);
			
			btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			btnBack.x = 940; btnBack.y = 4;
			btnBack.addEventListener(MouseEvent.CLICK, volver);
			addChild(btnBack);
			
		}
		
		private function cargaTerreno() {
			fondo = new Loader();
			
			var urlReq:URLRequest = new URLRequest(p.hFondos[ej.fondo].url);
			fondo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			fondo.load(urlReq);
			this.addChild(fondo);
		}
		
		
		private function LoadElements() {
			
			//	Calcula proporcion
			var f: FondoBE = p.hFondos[ej.fondo];
			var prop: Number = f.altura / f.altura_m;
			if (ej.escenas.length == 0) return;
			var escena: EscenaBE = ej.escenas[1];
			
			//var tl: TimelineLite = new TimelineLite();
			new SoundPlayer("C:\\Users\\Pots\\Documents\\piz\\audios\\audio_27_1.mp3").Play();
			for each(var m: MovimientoBE in escena.movimientos) {
				var el: ElementoBE = p.hElementos[m.elemento];
				var img: Image = new Image(el.imagen, el.altura * prop, el.anchura * prop);
				img.x = fondo.x + m.inicio.x;
				img.y = fondo.y + m.inicio.y;
				addChild(img);
				els.push(img);
				//for each (var tr: TrayectoriaBE in m.trayectoria) {
				//	tl.append(new TweenLite(img, 0.5, { x:tr.punto.x, y: tr.punto.y } ));
				//}
			}
			trace("els: " + els.length);
			AnimationHelper.GetExerciseAnimation(ej, els);
			//AnimationHelper.ExportaAnimacion(ej, "C:\\Users\\Pots\\Documents\\piz\\audios\\video.flv", 10);
			/*var tl: TimelineLite = new TimelineLite();
			
			for (var i = 1; i < ej.escenas.length; i++ ) {
				
				var esc: EscenaBE = ej.escenas[i];
				for (var j = 0; j < esc.movimientos; j++  ) {
					
					var m: MovimientoBE = esc.movimientos[j];
					for each (var tr: TrayectoriaBE in m.trayectoria) {
						tl.append(new TweenLite(els[j], esc.duracion, { x:tr.punto.x, y: tr.punto.y } ));
					}
				}
			}*/
		}
		
		private function createInfoPanel(){
			
			infoPanel.graphics.beginFill(Tema.secondBgA, 1);
			infoPanel.graphics.drawRect(0, 0, 500, 200);
            infoPanel.graphics.endFill();
			infoPanel.x = 500; infoPanel.y = 100;
			infoPanel.alpha = 0;
			this.addChild(infoPanel);
		}
		
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function dibujaTerreno(){
			pnVideo = new Sprite(); this.addChild(pnVideo);
			fondo = new Loader(); 
			var urlReq:URLRequest = new URLRequest(p.fondoEjercicio.url);
			fondo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			fondo.load(urlReq);
			pnVideo.addChild(fondo);
		}
		
		public function ShowInfoPanel(){
			trace("show");
			new Tween(infoPanel,"alpha",None.easeNone,0,1,1,true);
		}
		
		public function HideInfoPanel(){
			trace("hide");
			new Tween(infoPanel,"alpha",None.easeNone,1,0,1,true);
		}
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function imgLoaded(event:Event):void{
			
			switch(event.target.loader){
				case _atras:
					Util.posiciona(_atras,0,0,50,50);
					break;
				case _delante:
					Util.posiciona(_delante,60,0,50,50);
					break;
				case _pausa:
					Util.posiciona(_pausa,120,0,50,50);
					break;
				case _play:
					Util.posiciona(_play,180,0,50,50);
					break;
				case _reverse:
					Util.posiciona(_reverse,240,0,50,50);
					break;
				case fondo: 
					fondo.x = 100;
					fondo.y = 100;
					break;
				default:	trace("error cargando botonera");
			}
		}
		private function muestraBotonera(event:Event):void{
			if(event.currentTarget == event.target)
				TransitionManager.start(pnBotonera,{type:Fade, duration:1, direction:Transition.IN})
		}
		private function ocultaBotonera(event:Event):void{
			if(event.currentTarget == event.target)
				TransitionManager.start(pnBotonera,{type:Fade,duration:1 , direction:Transition.OUT})
		}
		
		private function play_Click(event:Event) {
			ex.Play();
		}
		
		private function pause_Click(event:Event) {
			ex.Stop();
		}
		
		private function frameChange(event:Event) {
			slider.value = ex.CurrentProgress * 1000;
		}
		
		private function finishedLoading(event:Event) {
			trace("finish");
			_slider.maximum = ex.Length * 1000;
		}
		
		private function changeTime(event: Event) {
			ex.CurrentProgress = slider.value;
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get atras(): Loader { return _atras; }
		public function get delante(): Loader { return _delante; }
		public function get pausa(): Loader { return _pausa; }
		public function get play(): Loader { return _play; }
		public function get reverse(): Loader { return _reverse; }
		public function get slider(): Slider { return _slider; }
		public function get BtnInfo(): TextImageButton { return btnInfo; }
		
		private function volver(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
	
	}
}