﻿/*
 * 		MAIN  MAIN
 * */

package org.pizarra
{
	import flash.display.Sprite;
	import flash.filesystem.File;
	import flash.net.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.InvokeEvent;
	import flash.desktop.NativeApplication;
		
	import org.pizarra.View.*;
	import org.pizarra.Controller.*;
	import org.pizarra.Model.*;
	import org.pizarra.Data.Base_Datos;
	import org.pizarra.graficos.*;
	import org.pizarra.Exceptions.*;
	import org.pizarra.util.Eventos;
	import org.pizarra.escenas.editor.PreEditorController;
	
	public class Main extends Sprite 
	{
		//private var visorView: VisorView;
		//private var visorController: VisorController;
		private var preEditorView: PreEditorView;
		private var preEditorController: PreEditorController;
		private var editorView: EditorView;
		private var editorController: EditorController;
		private var editorModel: EditorModel;
		private var cargaVista: CargaView = new CargaView();
		private var p: Pizarra;
		private var bd: Base_Datos;			//	Objeto de la base de datos
		private var fichero_data: String;
		
		public function Main()
		{
			//NativeApplication.nativeApplication.addEventListener(InvokeEvent.INVOKE, onInvoke);
			Init();
			
			cargaVista.texto = "Inicializando datos de la aplicación";
			//	We crate the p object as a model for most of the data of the aplication
			p = new Pizarra(bd);	
			p.init();			//	Initialize the component with data from database
			cargaVista.texto = "Cargados los datos de la aplicación";
			cargaVista.texto = "Resolviendo conflictos";
			p.resuelveConflictosenImagenes();
			p.stage = stage;
			cargaVista.texto = "Conflictos Resueltos";

			Alert.init(p.stage);
			
			preEditorView = new PreEditorView(p);
			preEditorController = new PreEditorController(p, preEditorView);
			preEditorController.init();
			preEditorController.addEventListener("volver", volverPreEditor);
			preEditorController.addEventListener(Eventos.CREAR_EJERCICIO, crearEditor);
			//preEditorController.addEventListener(Eventos.CREAR_DIBUJO, crearFreeEditor);
			addChild(preEditorView);
			
		}
		
		function volverPreEditor(event: Event){
			//removeChild(preEditorView);
			//addChild(menuView);
		}
		function crearEditor(event: Event){
			removeChild(preEditorView);
			editorModel = new EditorModel(p);
			editorView = new EditorView(editorModel);
			editorController = new EditorController(p, editorView);
			editorController.init();
			editorController.addEventListener("volver", volverEditor);
			addChild(editorView);
		}
		function volverEditor(event: Event){
			removeChild(editorView);
			addChild(preEditorView);
		}
		
/*
 *	<PRIVATE_FUNCTIONS> 
 */
	//	Init the App
	private function Init() {
		//	Create the loading view
		createLoadingView();
		checkReferences();
		startDatabase();
	}
	//		Create and load loading view
	private function createLoadingView() {
		addChild(cargaVista);
		cargaVista.texto = "Creando variables del programa";
	}
	
	//	Check paths to the files to create the app filesystem structure
	private function checkReferences() {
		cargaVista.texto = "Comprobando referencias de directorios y ficheros";
		if(! File.documentsDirectory.resolvePath("piz").exists){	//	Folder doesn't exist	
			//	Se debe copiar los elementos de la aplicación
			var local:File = File.applicationDirectory.resolvePath("piz");
			var docs:File = File.documentsDirectory.resolvePath("piz");
			local.copyTo(docs,false);
			Util.subTrace("Copiados los documentos");
		}else{							//	Aplicación ya inicializada
			Util.subTrace("existe el directorio " + File.documentsDirectory.resolvePath("piz").nativePath);
		}
		//	Load preferences
			var myLoader:URLLoader = new URLLoader();
			myLoader.load(new URLRequest(File.documentsDirectory.resolvePath("piz").resolvePath("App.Config").nativePath));
			myLoader.addEventListener(Event.COMPLETE, processXML);
			
			cargaVista.texto = "Referencias de directorios y ficheros correctas";		
	}
	
	private function processXML(e:Event):void {
		try{
			var myXML:XML = new XML(e.target.data);
			p.Environment = myXML.Environment;
			p.Log = myXML.Log;
			p.ExceptionLog = myXML.ExceptionLog;
		} catch (e: PizarraException) {
			trace("Error loading preferences");
		}
	}	
	
	//	Connects to the database
	private function startDatabase() {
		cargaVista.texto = "Conectando con la base de datos";
		try{
			bd = new Base_Datos("pizarra.db",cargaVista);
		}catch(error: Error){
			Util.subTrace("Error al iniciar la base de datos");
			cargaVista.texto = "Error fatal, no se pudo acceder a la base de datos."
			return ;
		}
		cargaVista.texto = "Conexión realizada correctamente";	
	}
	
	
/*
 *	</PRIVATE FUNCTIONS> 
 */
		 	 
/*
 *	<HANDLERS> 
 */
		function salir(event:Event) {	NativeApplication.nativeApplication.exit(0);	}
		 
/*
 *	</HANDLERS> 
 */
		
	function volverVisor(event: Event){
		//removeChild(visorView);
		//salir(null);
	}
	
	//	Gestión de la llamada de la aplicación
	function onInvoke(event:InvokeEvent):void{
		//fichero_data = "C:/Users/Pots/Desktop/bbb.piz";
		if(event.arguments.length > 0){
			fichero_data = event.arguments[0];
			var extension: String = fichero_data.split(".")[fichero_data.split(".").length-1];
			switch(extension){
				case "piz":	Util.subTrace("Argumento: fichero piz");
							Alert.show("Desea importar el fichero?", {background:"blur", buttons:["Sí", "No"], callback:handleResponse});
							break;
				case "pizd": Util.subTrace("Argumento: fichero pizd");
							p.urlEjercicio = fichero_data;
							break;
				case "flv":	Util.subTrace("Argumento: fichero flv");
							break;
				default:	Util.subTrace("Argumento: fichero no soportado");
							Alert.show("Fichero Incorrecto", {background:"blur"});
			}
		}
	}
	
	function handleResponse(response:String):void {
		if (response == "Sí") {
			trace("si");
		}
		
		if (response == "No") {
			//p.urlEjercicio = fichero_data;
			//visorView = new VisorView(p);
			//visorView.addEventListener(Eventos.BACK, volverVisor);
			//addChild(visorView);
		}
	}
	}
}