﻿package org.pizarra.Data{	

	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import flash.net.*;
	import flash.events.*;
	import org.pizarra.Util;
	import org.pizarra.Entity.*;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.util.Eventos;
	import org.pizarra.util.Constantes;
	
	public class Convert extends EventDispatcher{
		
		var ejXML: XML = <data></data>;
		
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function xmlAEjericio(url: String){
			Util.subTrace("Loading: " + url + " to an exercise");
			var xmlLoader:URLLoader = new URLLoader();
			xmlLoader.load(new URLRequest(url));
			xmlLoader.addEventListener(Event.COMPLETE, procesa_XML);
		}
		public function procesa_XML(e:Event):void {
		
			var xml: XML;
			try{
				xml = new XML(e.target.data);
				trace("-tipo: " + String(xml.type));
				if (String(xml.type) != Constantes.TYPE_EXERCISE){
					Util.subTrace("Error tipo documento");
					dispatchEvent(new Event(Eventos.WRONG_TYPE_IMPORT));
					return;
				}else{
					parseEjercicio(xml.ejercicio);
				}
			} catch (e:TypeError) {
				Util.subTrace("Error procesando XML");
				dispatchEvent(new Event(Eventos.ERROR_IMPORT));
				return;
         	}
		}
		public function ejericioAXML(e: Ejercicio): XML {
			
			var escena: XML = <escena></escena>;
			var auxEsc: Escena;
			var movimiento: XML = <movimiento></movimiento>;
			var auxMov: Movimiento;
			var punto: XML = <punto></punto>;
			
			e.imprime_ejercicio();
			
			Util.subTrace("Parsing: " + e.nombre + " to XML");
			ejXML.type = "Ejercicio";
			ejXML.ejercicio.id = e.id; 
			ejXML.ejercicio.nombre = e.nombre;
			ejXML.ejercicio.info = e.info;
			ejXML.ejercicio.fecha = e.fecha;
			ejXML.ejercicio.tipo = e.tipo;
			ejXML.ejercicio.deporte = e.deporte;
			ejXML.ejercicio.fondo = e.fondo;
			
			for (var i = 1; i < e.numEscenas ; i++ ) {	//	Para todas las escenas
				
				escena = <escena></escena>;
				auxEsc = e.escenas[i];
				escena.id_ejercicio = e.id;
				escena.id_escena = auxEsc.ID;
				escena.tipo = auxEsc.tipo;
				escena.duracion = auxEsc.duracion;
				escena.audio = auxEsc.audio;
				escena.texto = auxEsc.texto;
				
				for (var j = 0; j < auxEsc.nMovimientos ; j++ ) {	//	Para todos los movientos
					
					movimiento = <movimiento></movimiento>;
					auxMov = auxEsc.movimientos[j];
					movimiento.id_ejercicio = e.id;
					movimiento.id_escena = auxEsc.ID;
					movimiento.id_movimiento = auxMov.id;
					movimiento.secuencia = auxMov.secuencia;
					movimiento.tipo = auxMov.tipo;
					movimiento.elemento = auxMov.elemento;
					movimiento.inicio_x = auxMov.inicio.x;
					movimiento.inicio_y = auxMov.inicio.y;
					movimiento.fin_x = auxMov.fin.x;
					movimiento.fin_y = auxMov.fin.y;
					movimiento.etiqueta = auxMov.etiqueta;
					movimiento.rotacion = auxMov.rotacion;
					
					for each(var pto in auxMov.trayectorias ) {		//	For all points
						
						punto = <punto></punto>
						punto.x = pto.x;
						punto.y = pto.y;
						movimiento.puntos = punto;
					}
					escena.movimientos = movimiento;
				}
				ejXML.ejercicio.escenas = escena; 
			}
			return ejXML;
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function parseEjercicio(e: XMLList): Ejercicio{
			
			var ej: Ejercicio;
			var es: Escena;
			var esc: Array = new Array();
			var mov: Movimiento;
			var movs: Array = new Array();
			var aux_e: XMLList;
			var aux_m: XMLList;
						
			ej = new Ejercicio("", e.nombre, e.info, e.fecha, e.tipo, e.deporte, e.fondo);
			for(var i=1; i< e.b.escena.length(); i++){
				aux_e = e.b.escena[i];
				trace(aux_e.movimientos.movimiento[0]);
				es = new Escena(aux_e.id_escena, aux_e.tipo, aux_e.duracion, aux_e.texto, aux_e.audio);
				es.escribe_escena();
				for(var j=0; j< aux_e.movimientos.movimiento.length(); j++){
					aux_m = aux_e.movimientos.movimiento[j];
					trace(aux_m);
				}
			}
			ej.imprime_ejercicio();
			dispatchEvent(new Event(Eventos.FINISHED_IMPORT));
			return ej;
		}
		
	}
	
}