package org.pizarra.DAL {	
	
	import flash.data.*;
	import flash.errors.*;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	import org.pizarra.Entity.*;
	import org.pizarra.util.*;
	import org.pizarra.Util;
	
	public class DeporteDA{
		
		private var con: SQLConnection;
		private var result: SQLResult;
		
		public function DeporteDA(bdRef: SQLConnection) {
			con = bdRef;
		}
		
		/*
		 *	Lee todos los deportes de la base de datos
		 */
		public function getDeportes():Array{
			
			var deportes: Array = new Array();
			var selectStmt: SQLStatement = new SQLStatement();
			var deporteBE: DeporteBE;
			try {
				selectStmt.sqlConnection = con;
				selectStmt.text = "SELECT Id, Nombre, Thumb FROM " + DBConstants.T_DEPORTES;
				selectStmt.execute();
   				result = selectStmt.getResult();
   				if(result.data.length > 0){
					for each(var row in result.data){
						deporteBE = new DeporteBE();
						deporteBE.id = row['Id'];
						deporteBE.nombre = row['Nombre'];
						deporteBE.thumb = row['Thumb'];
						deporteBE.fondos = leeFondos(deporteBE.id);
						deportes.push(deporteBE);
						trace('push');
					}
				}
			}catch (error:SQLError){
				throw new Error(error.message + error); 
  				return null;
			}
			return deportes;
		}
		
		public function leeFondos(id: String):Array{
			
			var fondos: Array = new Array();
			var selectStmt: SQLStatement = new SQLStatement();
			var fondo: FondoBE;
			var res: SQLResult;
			try {
				selectStmt.sqlConnection = con;
				selectStmt.text  = "SELECT Id, Imagen, Nombre, Wm, Hm, Wpx, Hpx";
				selectStmt.text += " FROM " + DBConstants.T_FONDOS;
				selectStmt.text += " WHERE IdDeporte = @Id";
				selectStmt.parameters["@Id"] = id;
				selectStmt.execute();
   				res = selectStmt.getResult();
   				if(res.data.length > 0){
					for each(var row in res.data) {
						fondo = new FondoBE(
									String(row['Id']),
									String(row['Imagen']),
									String(row['Nombre']),
									int(row['Hm']),
									int(row['Wm']),
									int(row['Hpx']),
									int(row['Wpx']));
						fondos.push(fondo);
					}
				}else {
					trace('sin resultados');
				}
			}catch (error:SQLError) {
				Util.subTrace(error.message + error);
				throw new Error(error.message + error); 
  				return null;
			}
			return fondos;
		}
		
		public function leeHFondos():Dictionary{
			
			var fondos: Dictionary = new Dictionary();
			var selectStmt: SQLStatement = new SQLStatement();
			var fondo: FondoBE;
			var res: SQLResult;
			try {
				selectStmt.sqlConnection = con;
				selectStmt.text  = "SELECT Id, Imagen, Nombre, Wm, Hm, Wpx, Hpx";
				selectStmt.text += " FROM " + DBConstants.T_FONDOS;
				selectStmt.execute();
   				res = selectStmt.getResult();
   				if(res.data.length > 0){
					for each(var row in res.data) {
						fondo = new FondoBE(
									String(row['Id']),
									String(row['Imagen']),
									String(row['Nombre']),
									int(row['Hm']),
									int(row['Wm']),
									int(row['Hpx']),
									int(row['Wpx']));
						fondos[fondo.id] = fondo;
						trace(fondo.url);
					}
				}else {
					Util.subTrace('No hay fondos que leer');
				}
			}catch (error:SQLError) {
				Util.subTrace(error.message + error);
				throw new Error(error.message + error); 
  				return null;
			}
			return fondos;
		}
		
	}
}