﻿package org.pizarra.Controls {
	import fl.controls.Label;
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.text.*;
	import org.pizarra.configuracion.Tema;
	
	public class ImageToggleButton extends Sprite {
		
		private var CONTROL_WIDTH: uint = 32;
		private var CONTROL_HEIGHT: uint = 32;
		
		private var l: Loader = new Loader();
		private var disableSprite: Sprite = new Sprite();
		private var text: Label = new Label();
		private var _enabled: Boolean = true;
		private var Pressed: Boolean = false;
		
		public function ImageToggleButton(url: String) {
			//	Load the image
			DrawBackground();
			LoadImage(url);
			CreateDisabler();
			buttonMode = true;
			this.addEventListener(MouseEvent.CLICK, button_Clicked);
		}
		
		/*	PUBLIC
		 **/
		public function set Enabled(state: Boolean) {
			disableSprite.visible = !state;
		}
		 
		
		/*	PRIVATE FUNCTIONS
		 **/
		private function LoadImage(url: String): void {
			
			l.load(new URLRequest(url));
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			l.x = 4; l.y = 4;
			addChild(l);
		}
		
		private function LoadText(name: String): void {
			
			var myTextFormat:TextFormat = new TextFormat();
			myTextFormat.align = TextFormatAlign.CENTER;
			myTextFormat.size = 15;

			text.text = name;
			text.y = 40;
			text.x = 0;
			text.setStyle("textFormat", myTextFormat);
			text.width = 80;
			text.buttonMode = true;
			addChild(text);
		}
		
		private function DrawBackground() {
			
			//	Background
			this.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			this.graphics.beginFill(Tema.ButtonBackground);
            this.graphics.drawRoundRect(0, 0, CONTROL_WIDTH, CONTROL_HEIGHT,20,20);
            this.graphics.endFill();
		}
		
		private function CreateDisabler(): void {
			
			disableSprite = new Sprite();
			disableSprite.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			disableSprite.graphics.beginFill(Tema.ButtonBackground, 0.5);
            disableSprite.graphics.drawRoundRect(0, 0, CONTROL_WIDTH, CONTROL_HEIGHT,20,20);
            disableSprite.graphics.endFill();
			addChild(disableSprite);
			disableSprite.visible = false;
			disableSprite.addEventListener(MouseEvent.CLICK, clicked);
		}
		
		/*	HANDLERS
		 **/
		private function imgLoaded(event:Event):void {
			l.width = 24;
			l.height = 24;
		}
		
		private function clicked(event:Event): void {
			event.stopImmediatePropagation();
			event.stopPropagation();
		}
		
		private function button_Clicked(ev: Event): void{
			this.Pressed = !this.Pressed;
			if(Pressed){
				this.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			this.graphics.beginFill(Tema.ButtonBackgroundPressed);
            this.graphics.drawRoundRect(0, 0, CONTROL_WIDTH, CONTROL_HEIGHT,20,20);
            this.graphics.endFill();
			}else{
				this.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			this.graphics.beginFill(Tema.ButtonBackground);
            this.graphics.drawRoundRect(0, 0, CONTROL_WIDTH, CONTROL_HEIGHT,20,20);
            this.graphics.endFill();
			}
			
			this.dispatchEvent( new Event(Event.CHANGE) );
		}
	}
}