﻿package org.pizarra.Controller{	

	import fl.accessibility.DataGridAccImpl;
	import flash.events.*;
	import flash.geom.Point;
	import flash.utils.Dictionary;
	import org.pizarra.BLL.EjerciciosBL;
	import org.pizarra.DAL.EjercicioDA;
	import org.pizarra.Entity.*;
	import org.pizarra.*;
	import org.pizarra.graficos.*;
	import org.pizarra.View.EditorView;
	import org.pizarra.acciones.*;

	import org.pizarra.util.Constantes;
	import org.pizarra.Animation.TransformationManager.*;
	import org.pizarra.util.Eventos;
	import org.pizarra.util.Acciones;
	import org.pizarra.util.GUID;
	import flash.filesystem.File;
	import org.pizarra.Converters.ExerciseConverter;
	import flash.filesystem.FileStream;
	import flash.filesystem.FileMode;

	public class EditorController extends EventDispatcher{
		
		private var ERROR_POSITION = new Point( -1000, -1000);
		
		private var p: Pizarra;
		private var editor: EditorView;
		private var ej: EjercicioBE;
		//	Elementos
		private var elementos: Array = new Array();	//	Represents id for the added element
		private var items:Array = new Array();		//	Represents ElementId for the different items
		private var escenas: Array = new Array();	//	Sets the state of the scene[]
		
		private var idEscenas: Array = new Array();
		private var idMovimientos: Array = new Array();
		private var trayectorias: Array = new Array();
		private var preAcciones: Array = new Array();
		private var postAcciones: Array = new Array();
		private var duraciones: Array = new Array();
		private var audios: Array = new Array();
		private var textos: Array = new Array();
		private var tipos: Array = new Array();
		private var etiquetas: Dictionary = new Dictionary();
		
		//	Historial de acciones
		private var acciones: Array = new Array();
		private var accion: int = -1;
		
		//	Estado
		private var e_actual: int = 1;
		private var e_ultima: int = 1;
		private var fase_actual: int = Constantes.POSICIONAMIENTO;
		private var fase_ultima: int = Constantes.POSICIONAMIENTO;
		
		public var lastElementId: String = "";
		public var lastElement: Elemento_Concreto = null;
		
		public function EditorController(piz: Pizarra, editor: EditorView): void{
			p = piz;
			this.editor = editor;
			Alert.init(p.stage);
			editor.volver.addEventListener(MouseEvent.CLICK, volver);
			editor.guardar.addEventListener(MouseEvent.CLICK, guardar);
			editor.setController(this);
			
			editor.TbDelete.addEventListener(MouseEvent.CLICK, btnDelete_Click);
			editor.TbDeletePrev.addEventListener(MouseEvent.CLICK, btnDeletePrev_Click);
			editor.TbDeletePost.addEventListener(MouseEvent.CLICK, btnDeletePost_Click);
			editor.TbDeleteScene.addEventListener(MouseEvent.CLICK, btnDelete_Click);
			
			editor.TbRemovePath.addEventListener(MouseEvent.CLICK, btnRemovePath_Click);
			editor.TbContinuePath.addEventListener(MouseEvent.CLICK, btnContinuePath_Click);
			
			editor.ButtonPanel.addEventListener(Eventos.BTN_ADD, newScene_Click);
			//editor.ButtonPanel.addEventListener(Eventos.BTN_PREVIEW, preview);
			//editor.ButtonPanel.addEventListener(Eventos.BTN_REDO, undo);
			//editor.ButtonPanel.addEventListener(Eventos.BTN_UNDO, redo);
			
			editor.CbPostActions.addEventListener(Event.CHANGE, actions_Change);
			editor.CbPreActions.addEventListener(Event.CHANGE, actions_Change);
			
			//	Create exercise infrastructure
			ej = new EjercicioBE();
			ej.id = Util.nuevoId();
			ej.nombre = p.nombre;
			ej.info = p.informacion;
			ej.tipo = p.tipo_ejercicio;
			ej.fondo = p.fondoSeleccionado.id;
			ej.deporte = p.deporteSeleccionado;
			ej.fechaCreacion = new Date();
			ej.fechaModificacion = new Date();
			
			//	Set timeline references
			editor.LineaTiempo.Escenas = escenas;
			editor.LineaTiempo.Trayectorias = trayectorias;
			editor.LineaTiempo.Elementos = elementos;
			editor.LineaTiempo.Items = items;
			editor.LineaTiempo.Urls = p.hElementos;
			
			editor.TransformManager.addEventListener(FreeTransformEvent.ON_TRANSFORM, onTransform);
			editor.TransformManager.addEventListener(MouseEvent.MOUSE_UP, onFinishedTransform);
			editor.PnEscena.addEventListener(Event.CHANGE, escenaData_Change);
		}
		
		public function init() {
			iniciaGeneralesEscena(); 	//	Initialize the data structures
		}
		
		public function moveElement(e: Elemento_Concreto) {
			acciones.push( new MoveAction(e.Id, e_actual, new Point(e.x, e.y), e.anterior)); accion ++; 
			//	Save Scene
			escenas[e_actual][e.Id] = new Estado(new Point(e.x, e.y), e.rotation);
			escenas[e_actual][e.Id].IdElemento = e.IdElemento;
			editor.LineaTiempo.Update();
		}
		
		/*public function rotateElement(e: Elemento_Concreto) {
			escenas[e_actual][e.Id] = new Estado(new Point(e.x,e.y),e.rotation);
		}*/
		
		public function addElement(e: Elemento_Concreto) {
		
			acciones.push( new AddAction(e.id) ); accion ++; 
			elementos.push(e.Id);		//	Add to the element id array
			items.push(e.IdElemento)	//	Add the model element
			
			//	Create the state, todo handle insert in middle scene
			for (var i = 1; i < escenas.length; i++ ){
				escenas[i][e.Id] = new Estado(new Point(e.x, e.y), e.rotation);
				escenas[i][e.Id].IdElemento = e.IdElemento;
				preAcciones[i][e.Id] = GUID.Empty;
				postAcciones[i][e.Id] = GUID.Empty;
			}
			
			//	Create the path
			trayectorias[e_actual][e.Id] = new Trayectoria(new Point(e.x, e.y));
			etiquetas[e.Id] = e.elemento.nombre;
			//	Actualiza movimiento
			idMovimientos[e_actual][e.Id] = Util.nuevoId();
			
			this.lastElement = e;
			this.lastElementId = e.Id;
			
			editor.LineaTiempo.Reload();
			
			var acc: Array = new Array();
			if(this.p.Acciones[this.lastElement.elemento.id] != undefined){
				acc = this.p.Acciones[this.lastElement.elemento.id];
			}
			editor.UpdateCombosAcciones(acc, preAcciones[e_actual], postAcciones[e_actual]);
		}
		
		/*	DELETE
		 =======================================================*/
		public function DeleteElement(id: String) {
			var n: int = elementos.indexOf(id);
			trace("deleting " + id);
			//	 Delete from elementos, escenas, ids
			elementos.splice(n, 1);
			items.splice(n, 1);
			for( var i = 1; i < escenas.length; i++ ) {
				delete escenas[i][id];
			}
			editor.LineaTiempo.Reload();
		}
		
		public function DeleteAnteriores(id: String) {
			trace(id);
			for (var i = 1; i < e_actual; i++ ) {
				escenas[i][id].posicion = ERROR_POSITION;
			}
			editor.LineaTiempo.Reload();
		}
		
		public function DeletePosteriores(id: String) {
			if (e_actual + 1 < escenas.length) {
				for (var i = e_actual+1; i < escenas.length; i++ ) {
					escenas[i][id].posicion = ERROR_POSITION;
				}
			}
			editor.LineaTiempo.Reload();
		}
		 
		public function newScene() {
			transitaEstado();	//	Intercambia la fase
			if (fase_actual == Constantes.POSICIONAMIENTO) {
				//	Crea la estructura de la nueva escena
				iniciaGeneralesEscena();
				//	Rellena
				for each(var el: String in elementos) {
					setNextPosition(e_actual,el);
					trayectorias[e_actual][el] = new Trayectoria(escenas[e_actual][el].posicion);
					preAcciones[e_actual][el] = GUID.Empty;
					postAcciones[e_actual][el] = GUID.Empty;
				}
				editor.LineaTiempo.Reload();
			}
		}
		
		//	Sets the position for the recently created scene
		private function setNextPosition(escena: int, id: String) {
			var posicion: Point;
			var rotacion: int;
			if (!trayectorias[escena - 1][id].isEmpty()) {
			//	La escena anterior tiene una trayectoria
			//	Must assign the last point
				posicion = trayectorias[escena - 1][id].last;
			}else {
			//	No tiene trayectoria
			//	Asigno la ultima posicion
				posicion = escenas[escena - 1][id].posicion;
			}
			escenas[escena][id] = new Estado(posicion, rotacion);
		}
		
		public function isSiguenteTrayectorias() {
			return fase_ultima == Constantes.POSICIONAMIENTO;
		}
		
		public function transitaEstado() {
			//	Cambia la fase y se posiciona en el ultima elemento (el creado)
			if (fase_ultima == Constantes.POSICIONAMIENTO) {
				fase_ultima = Constantes.TRAYECTORIAS;
			}else {
				fase_ultima = Constantes.POSICIONAMIENTO;
				e_ultima ++;
			}
			e_actual = e_ultima;
			fase_actual = fase_ultima;	
		}
		
		//	A new scene has been selected
		public function posiciona(escena: int, fase: int) {
			e_actual = escena;
			fase_actual = fase;
			
			//	Set all the elements for the scene
			//	PnEscena
			editor.PnEscena.texto = this.textos[e_actual];
			editor.PnEscena.duracion = this.duraciones[e_actual];
			editor.PnEscena.audio = this.audios[e_actual];
			editor.PnEscena.tipo = this.tipos[e_actual];
			
			//	Actions
			editor.CbPreActions.selectedIndex = Util.findItemIndex(editor.CbPreActions, this.preAcciones[e_actual][this.lastElementId]);
			editor.CbPostActions.selectedIndex = Util.findItemIndex(editor.CbPostActions, this.postAcciones[e_actual][this.lastElementId]);
			
		}
		
		public function undo() {
			
			if (acciones[accion] is AddAction) {
				undoAdd();
				accion--; trace("Add historial " + accion);
			}
			if (acciones[accion] is MoveAction) {
				undoMove();			
				accion--; trace("Move historial " + accion);
			}
			/**/
		}
		
		/*
		 * 	HANDLE SCENES
		 */
		public function escena( n: int): Dictionary { return escenas[n]; }
		 
		public function actualizaGeneralesEscena(duracion: int, tipo: String, audio: String, texto: String) {
			duraciones[e_actual] = duracion;
			textos[e_actual] = texto;
			audios[e_actual] = audio;
			tipos[e_actual] = tipo;
		}
		
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function undoAdd() {
			var action: AddAction = acciones[accion];
			
			for each (var escena: Dictionary in escenas) {
				//trace(escena[action.id].rotacion + " " + action.id);
				delete escena[action.id];
			}
			trace("---> Removing element " + action.id);
			editor.eliminaElemento(action.id);
		}
		
		private function undoMove() {
			var action: MoveAction = acciones[accion];
			escenas[action.scene][action.id].posicion = action.end;
			trace("---> Move from " + action.start + " to " + action.end);
		}
		
		//	inicia las estructuras de datos para la nueva escena
		private function iniciaGeneralesEscena() {
			escenas[e_actual] = new Dictionary();
			trayectorias[e_actual] = new Dictionary();
			idEscenas[e_actual] = Util.nuevoId();
			idMovimientos[e_actual] = new Dictionary();
			preAcciones[e_actual] = new Array();
			postAcciones[e_actual] = new Array();
			for each(var el in elementos) {
				var estadoAnterior: Estado = escenas[e_actual - 1][el];
				escenas[e_actual][el] = new Estado(estadoAnterior.posicion, estadoAnterior.rotacion);
				escenas[e_actual][el].IdElemento = el;
				idMovimientos[e_actual][el] = Util.nuevoId();
				preAcciones[e_actual][el] = GUID.Empty;
				postAcciones[e_actual][el] = GUID.Empty;
			}
			duraciones[e_actual] = Constantes.TIEMPO_ESCENA_DEFECTO;
			textos[e_actual] = "";
			audios[e_actual] = "";
			tipos[e_actual] = Constantes.TIPO_ESCENA_DEFECTO;
		}
		

		/**************************************
		 *		PUBLIC FUNCTIONS
		 **************************************/
		public function setPath(t: Trayectoria, id: String) {
			trace("setting path for element " + id + " on scene " + e_actual );
			trayectorias[e_actual][id] = t;
			//	Adjust the first point of the next scene to the las point for the path
			if(t != null && t.Puntos != null && t.Puntos[t.Puntos.length - 1] != undefined
			   && e_actual < escenas.length - 1){
				   if(t.tipo == Acciones.ZIGZAG 
					  || t.tipo == Acciones.ZIGZAG_DIS){
					   escenas[e_actual + 1][id].posicion = t.Puntos[t.Puntos.length - 1];
						editor.LineaTiempo.Reload();
				   }
				   if(t.tipo == Acciones.CIRCULAR 
					  || t.tipo == Acciones.CIRCULAR_DIS){
					    escenas[e_actual + 1][id].posicion = t.Puntos[0];
						editor.LineaTiempo.Reload();
				   }
			}
		}
		
		public function GenerateExercise(): void {
			
			//	Parse scenes
			for (var i: int = 1; i < escenas.length; i++ ) {
			//	For each scene	
				var esc: EscenaBE = new EscenaBE();
				esc.id = idEscenas[i];
				esc.ejercicio = ej.id;
				esc.tipo = tipos[i];
				esc.orden = i;
				esc.duracion = duraciones[i];
				esc.audio = audios[i];
				esc.texto = textos[i];
				var j: int = 0;
				for (var value:String in trayectorias[i]) {
					var tr : Trayectoria = trayectorias[i][value];
					var estado: Estado = this.escenas[i][value];
					var mov: MovimientoBE = new MovimientoBE();
					mov.id = GUID.create();
					mov.preAccion = preAcciones[i][value];
					mov.postAccion = postAcciones[i][value];
					mov.orden = j;
					mov.elemento = this.editor.Elements[value].elemento.id;
					mov.tipo = "00" + (tr != null ? tr.tipo : "0");
					mov.rotacion = estado.rotacion;
					mov.inicio = estado.posicion;
					mov.etiqueta = "";
					if(tr != null){
						for(var k = 0; k < tr.Puntos.length; k++){
							var tray: TrayectoriaBE = new TrayectoriaBE();
							tray.movimiento = mov.id;
							tray.orden = k;
							tray.punto = tr.Puntos[k];
							mov.trayectoria[k] = tray;
						}
					}
					esc.movimientos[j] = mov;
					j++;
				}
				ej.escenas[i] = esc;
			}
		}
		
		/**************************************
		 *		PRIVATE FUNCTIONS
		 **************************************/
		private function doRemovePath(response:String):void {
			if (response == "Sí") {
				trayectorias[e_actual][this.lastElementId] = null;
				editor.AddIndividualPathSprite(this.lastElement);
				editor.LineaTiempo.Reload();
			}
		}
		
		function doDelete(response:String):void {
			if (response == "Sí") {
				doDeleteElement(null);
			}
		}
		
		function doDeletePrev(response:String):void {
			if (response == "Sí") {
				var el:Elemento_Concreto = lastElement;
				DeleteAnteriores(el.Id);
			}
		}
		
		function doDeletePost(response:String):void {
			if (response == "Sí") {
				var el:Elemento_Concreto = lastElement;
				DeletePosteriores(el.Id);
			}
		}
		
		/**************************************
		 *		HANDLERS
		 **************************************/
		private function btnContinuePath_Click(ev: MouseEvent){
			editor.ContinuePath();
		}
		
		private function btnRemovePath_Click(ev: MouseEvent){
			if(this.lastElement != null){
				Alert.show("¿Desea borrar la trayectoria completa?", {buttons:["Sí", "No"], callback: doRemovePath});
			}else{
				Alert.show("Seleccione un elemento primero");
			}
		}
		
		private function doDeleteElement(e:Event) {
			var el:Elemento_Concreto = lastElement;
			DeleteElement(el.Id);
			editor.CleanElemento(el);
		}
		
		private function newScene_Click(ev: Event){
			editor.LineaTiempo.CreateNewScene();
			e_actual ++;
			iniciaGeneralesEscena();
			for each(var el: String in elementos) {
				setNextPosition(e_actual,el);
				trayectorias[e_actual][el] = new Trayectoria(escenas[e_actual][el].posicion);
			}
			editor.LineaTiempo.Reload();
		}
		
		private function btnDelete_Click(ev: MouseEvent){
			if(this.lastElement != null){
				Alert.show("¿Desea borrar el elemento para todas las escenas?", {buttons:["Sí", "No"], callback:doDelete});
			}else{
				Alert.show("Seleccione un elemento primero");
			}
		}
		
		private function btnDeletePrev_Click(ev: MouseEvent){
			if(this.lastElement != null){
				Alert.show("¿Desea borrar el elemento para las anteriores escenas?", {buttons:["Sí", "No"], callback:doDeletePrev});
			}else{
				Alert.show("Seleccione un elemento primero");
			}
		}
		
		private function btnDeletePost_Click(ev: MouseEvent){
			if(this.lastElement != null){
				Alert.show("¿Desea borrar el elemento para las siguientes escenas?", {buttons:["Sí", "No"], callback:doDeletePost});
			}else{
				Alert.show("Seleccione un elemento primero");
			}
		}
		
		//	Handler for the selection of an element
		private function elementClicked(el: Elemento_Concreto): void{
			editor.FinishEdition();
			if(el != null && el.Id != this.lastElementId){
				this.lastElementId = el.Id;
				//	Load combo for element
				var acciones: Array = new Array();
				if(this.p.Acciones[this.lastElement.elemento.id] != undefined){
					acciones = this.p.Acciones[this.lastElement.elemento.id];
				}
				editor.UpdateElementName(el.elemento.nombre);
				editor.UpdateCombosAcciones(acciones, preAcciones[e_actual][el.Id], postAcciones[e_actual][el.Id]);
			}
		}
		
		private function volver(event: Event){
			dispatchEvent(new Event("volver"));
		}
		
		//	Save the currently editing EExercise
		private function guardar(event: Event) {
			try{
			GenerateExercise();
			ej.print();
			var DA = new EjercicioDA(p.bd.conexion);
			var msg = DA.writeExercise(ej);
			if (msg == "Ejercicio Insertado correctamente"){
				this.p.ejercicios.push(ej);
				this.p.hEjercicios[ej.id] = ej;
			}
			Alert.show(msg, {background:"blur"});
			}catch(err: Error){
				Util.subTrace(err.getStackTrace());
				Alert.show("Error Saving Exercise");
			}
		}
		
		public function onTransform(ev: FreeTransformEvent){
			
			var el: Elemento_Concreto = ev.targetObject as Elemento_Concreto;

			this.moveElement(el);
			this.lastElement = el;
			
			editor.UpdateButtonsOnSelection(el);
			editor.AddIndividualPathSprite(el);
			
			//	Update the previous path
			if(e_actual - 1 > 0 
			   && trayectorias[e_actual - 1] != null
			   && trayectorias[e_actual - 1][el.Id] != null){
				trayectorias[e_actual - 1][el.Id].LastPoint = new Point(el.x, el.y);
			}
			elementClicked(el);
		}
		
		public function onFinishedTransform(ev: MouseEvent){
			if(lastElement.x < 0 || lastElement.y < 0){
				lastElement.x = 0;
				lastElement.y = 0;
				editor.TransformManager.updateAfterChange();
			}
		}
		
		private function actions_Change(ev: Event){
			//	Save actions for the current Scene
			preAcciones[e_actual][this.lastElementId] = editor.CbPreActions.selectedItem.data;
			postAcciones[e_actual][this.lastElementId] = editor.CbPostActions.selectedItem.data;
			trace(editor.CbPreActions.selectedItem.data + " , " + editor.CbPostActions.selectedItem.data);
		}
		
		private function escenaData_Change(ev: Event): void{
			duraciones[e_actual] = editor.PnEscena.duracion;
			textos[e_actual] = editor.PnEscena.texto;
			audios[e_actual] = editor.PnEscena.audio;
			tipos[e_actual] = editor.PnEscena.tipo;
		}
		
		/**************************************
		 *		GETTERS SETTERS
		 **************************************/
		public function get escenaActual(): Dictionary { return escenas[e_actual]; }
		public function getEscena(i: int): Dictionary { return escenas[i]; }
		public function get ultima(): int { return e_ultima; }
		public function get fase(): int { return fase_actual; }
		public function get esc(): int { return e_actual; }
		public function getAudio(): String { return audios[e_actual]; }
		public function getTexto(): String { return textos[e_actual]; }
		public function getTipo(): String { return tipos[e_actual]; }
		public function getDuracion(): int { return duraciones[e_actual]; }
		public function getPath(id): Trayectoria { return trayectorias[e_actual][id]; }
		
		
		/**************************************
		 *		DEBUG
		 **************************************/
		public function muestraTrayectorias() {
			for each(var t: Trayectoria in trayectorias[e_actual]) {
				t.audita();
			}
		}
		
		public function saveExerciseToFile(): void{
			var ejXml: XML;
			GenerateExercise();
			p.urlEjercicio = File.desktopDirectory.nativePath + "\\" + ej.nombre + ".piz";
			
			try{
				ejXml = ExerciseConverter.EjericioBeToXml(ej);
				escribeFichero(ejXml, p.urlEjercicio );
				Alert.show("Exportado Fichero " + ej.nombre + " a " + p.urlEjercicio , { background:"blur" } );
			}catch(e: Error){
				Alert.show("Error exportado fichero" , { background:"blur" } );
				trace(e.getStackTrace());
			}
		}
		
		public function GetExercise(): EjercicioBE{
			GenerateExercise();
			return ej;
		}
		
		private function escribeFichero(ej: XML, fichero: String) {
			
			var file:File = File.desktopDirectory.resolvePath( fichero);
			var stream: FileStream = new FileStream();
			stream.open( file, FileMode.WRITE );
			stream.writeUTFBytes( ej.toXMLString());
			stream.close();
			file = null; stream = null; 
		}
		
	}
}