package org.pizarra.BLL {
	
	import flash.display.Loader;
	import org.pizarra.Pizarra;
	import org.pizarra.util.Constantes;
	import flash.net.URLRequest;
	import org.pizarra.Entity.*;
	import org.pizarra.util.*;
	
	public class EjerciciosBL {
		
		public static function GetExercisesForGrid(): Array {
			
			var ejs: Array = Pizarra._ejercicios;
			var dibujos: Array = Pizarra._dibujosLibres;
			var elements:Array = new Array();
			var l: Loader = new Loader();
			l.load(new URLRequest("http://www.helpexamples.com/flash/images/image1.jpg"));
			
			for (var i: int = 0; i < ejs.length; i += 1 ) {
				var sTipo: String;
				switch(ejs[i].tipo) {
					case Constantes.EJERCICIO: sTipo = Constantes.S_EJERCICIO;
								break;
					case Constantes.JUGADA: sTipo = Constantes.S_JUGADA;
								break;
					case Constantes.DISPOSICION: sTipo = Constantes.S_DISPOSICION
								break;
					default:	sTipo = "Otro";
				}
				
				elements.push(
							{data: l,
							ID: ejs[i].id, 
							Nombre: ejs[i].nombre, 
							Info: ejs[i].info,
							Tipo: sTipo,
							Fecha: ejs[i].fechaCreacion } );
			}
			
			for (var i: int = 0; i < dibujos.length; i += 1 ) {
				elements.push(
							{data: l,
							ID: dibujos[i].id, 
							Nombre: dibujos[i].titulo, 
							Info: dibujos[i].info,
							Tipo: "Disposición",
							Fecha: dibujos[i].fechaCreacion } );
			}
			
			return elements;
		}
		
		public static function GetVariante(myEj: EjercicioBE): EjercicioBE { 
			
			var ej: EjercicioBE = new EjercicioBE();
			ej.id = GUID.create();
			ej.deporte = myEj.deporte;
			ej.fechaCreacion = myEj.fechaCreacion;
			ej.fechaModificacion = myEj.fechaModificacion;
			ej.fondo = myEj.fondo;
			ej.info = myEj.info;
			ej.nombre = "variante " + myEj.nombre;
			ej.tipo = myEj.tipo;
			ej.escenas = new Array();
			
			for (var i = 1; i < myEj.escenas.length; i++ ) {	
				var escena: EscenaBE = new EscenaBE();
				var myEscena: EscenaBE = myEj.escenas[i];
				escena.id = GUID.create();
				escena.audio = myEscena.audio;
				escena.duracion = myEscena.duracion;
				escena.ejercicio = myEscena.ejercicio;
				escena.orden = myEscena.orden;
				escena.texto = myEscena.texto;
				escena.tipo = myEscena.tipo;
				escena.movimientos = new Array();
				ej.escenas[i] = escena;
			}
			return ej;
		}
		
	}
}